/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.cli.JadxCLIArgs;
import jadx.cli.JadxCLICommands;
import jadx.cli.LogHelper;
import jadx.core.plugins.JadxPluginManager;
import jadx.core.plugins.PluginContext;
import jadx.core.utils.Utils;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class JCommanderWrapper {
    private final JCommander jc;
    private final JadxCLIArgs argsObj;

    public JCommanderWrapper(JadxCLIArgs argsObj) {
        JCommander.Builder builder = JCommander.newBuilder().addObject((Object)argsObj);
        builder.acceptUnknownOptions(true);
        JadxCLICommands.append(builder);
        this.jc = builder.build();
        this.argsObj = argsObj;
    }

    public boolean parse(String[] args) {
        try {
            String[] fixedArgs = this.fixArgsForEmptySaveConfig(args);
            this.jc.parse(fixedArgs);
            this.applyFiles(this.argsObj);
            return true;
        }
        catch (ParameterException e) {
            System.err.println("Arguments parse error: " + e.getMessage());
            return false;
        }
    }

    public void overrideProvided(JadxCLIArgs obj) {
        this.applyFiles(obj);
        for (ParameterDescription parameter : this.jc.getParameters()) {
            if (!parameter.isAssigned()) continue;
            JCommanderWrapper.overrideProperty(obj, parameter);
        }
    }

    public boolean processCommands() {
        String parsedCommand = this.jc.getParsedCommand();
        if (parsedCommand == null) {
            return false;
        }
        return JadxCLICommands.process(this, this.jc, parsedCommand);
    }

    private void applyFiles(JadxCLIArgs argsObj) {
        argsObj.setFiles(this.jc.getUnknownOptions());
    }

    private static void overrideProperty(JadxCLIArgs obj, ParameterDescription parameter) {
        Parameterized parameterized = parameter.getParameterized();
        Object providedValue = parameterized.get(parameter.getObject());
        Object newValue = JCommanderWrapper.mergeValues(parameterized.getType(), providedValue, () -> parameterized.get((Object)obj));
        parameterized.set((Object)obj, newValue);
    }

    private static Object mergeValues(Class<?> type, Object value, Supplier<Object> prevValueProvider) {
        if (type.isAssignableFrom(Map.class)) {
            Map prevMap = (Map)prevValueProvider.get();
            return Utils.mergeMaps((Map)prevMap, (Map)((Map)value));
        }
        return value;
    }

    private String[] fixArgsForEmptySaveConfig(String[] args) {
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            String nextArg;
            String arg = args[i];
            if (!arg.equals("--save-config")) continue;
            int next = i + 1;
            if (next == len) {
                return JCommanderWrapper.insertEmptyArg(args, next, true);
            }
            if (next >= len || !(nextArg = args[next]).startsWith("-")) break;
            return JCommanderWrapper.insertEmptyArg(args, next, false);
        }
        return args;
    }

    private static String[] insertEmptyArg(String[] args, int i, boolean add) {
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(args));
        if (add) {
            strings.add("");
        } else {
            strings.add(i, "");
        }
        return strings.toArray(new String[0]);
    }

    public void printUsage() {
        LogHelper.setLogLevel(LogHelper.LogLevelEnum.ERROR);
        PrintStream out = System.out;
        out.println();
        out.println("jadx - dex to java decompiler, version: " + JadxDecompiler.getVersion());
        out.println();
        out.println("usage: jadx [command] [options] " + this.jc.getMainParameterDescription());
        out.println("commands (use '<command> --help' for command options):");
        for (String command : this.jc.getCommands().keySet()) {
            out.println("  " + command + "\t  - " + this.jc.getUsageFormatter().getCommandDescription(command));
        }
        out.println();
        int maxNamesLen = JCommanderWrapper.printOptions(this.jc, out, true);
        out.println(this.appendPluginOptions(maxNamesLen));
        out.println();
        out.println("Environment variables:");
        out.println("  JADX_DISABLE_XML_SECURITY - set to 'true' to disable all security checks for XML files");
        out.println("  JADX_DISABLE_ZIP_SECURITY - set to 'true' to disable all security checks for zip files");
        out.println("  JADX_ZIP_MAX_ENTRIES_COUNT - maximum allowed number of entries in zip files (default: 100 000)");
        out.println("  JADX_CONFIG_DIR - custom config directory, using system by default");
        out.println("  JADX_CACHE_DIR - custom cache directory, using system by default");
        out.println("  JADX_TMP_DIR - custom temp directory, using system by default");
        out.println();
        out.println("Examples:");
        out.println("  jadx -d out classes.dex");
        out.println("  jadx --rename-flags \"none\" classes.dex");
        out.println("  jadx --rename-flags \"valid, printable\" classes.dex");
        out.println("  jadx --log-level ERROR app.apk");
        out.println("  jadx -Pdex-input.verify-checksum=no app.apk");
    }

    public void printUsage(JCommander subCommander) {
        PrintStream out = System.out;
        out.println("usage: " + subCommander.getProgramName() + " [options]");
        JCommanderWrapper.printOptions(subCommander, out, false);
    }

    private static int printOptions(JCommander jc, PrintStream out, boolean addDefaults) {
        out.println("options:");
        List params = jc.getParameters();
        HashMap<String, ParameterDescription> paramsMap = new HashMap<String, ParameterDescription>(params.size());
        int maxNamesLen = 0;
        for (ParameterDescription p : params) {
            paramsMap.put(p.getParameterized().getName(), p);
            int len = p.getNames().length();
            String valueDesc = JCommanderWrapper.getValueDesc(p);
            if (valueDesc != null) {
                len += 1 + valueDesc.length();
            }
            maxNamesLen = Math.max(maxNamesLen, len);
        }
        maxNamesLen += 3;
        Object args = jc.getObjects().get(0);
        for (Field f : JCommanderWrapper.getFields(args.getClass())) {
            String defaultValue;
            String name = f.getName();
            ParameterDescription p = (ParameterDescription)paramsMap.get(name);
            if (p == null || p.getParameter().hidden()) continue;
            StringBuilder opt = new StringBuilder();
            opt.append("  ").append(p.getNames());
            String valueDesc = JCommanderWrapper.getValueDesc(p);
            if (valueDesc != null) {
                opt.append(' ').append(valueDesc);
            }
            JCommanderWrapper.addSpaces(opt, maxNamesLen - opt.length());
            String description = p.getDescription();
            if (description.contains("\n")) {
                String[] lines = description.split("\n");
                opt.append("- ").append(lines[0]);
                for (int i = 1; i < lines.length; ++i) {
                    opt.append('\n');
                    JCommanderWrapper.addSpaces(opt, maxNamesLen + 2);
                    opt.append(lines[i]);
                }
            } else {
                opt.append("- ").append(description);
            }
            if (addDefaults && (defaultValue = JCommanderWrapper.getDefaultValue(args, f)) != null && !defaultValue.isEmpty() && !description.contains("(default)")) {
                opt.append(", default: ").append(defaultValue);
            }
            out.println(opt);
        }
        return maxNamesLen;
    }

    @Nullable
    private static String getValueDesc(ParameterDescription p) {
        Parameter parameterAnnotation = p.getParameterAnnotation();
        return parameterAnnotation == null ? null : parameterAnnotation.defaultValueDescription();
    }

    private static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    @Nullable
    private static String getDefaultValue(Object args, Field f) {
        try {
            Enum val;
            Class<?> fieldType = f.getType();
            if (fieldType == Integer.TYPE) {
                return Integer.toString(f.getInt(args));
            }
            if (fieldType == String.class) {
                return (String)f.get(args);
            }
            if (Enum.class.isAssignableFrom(fieldType) && (val = (Enum)f.get(args)) != null) {
                return val.name().toLowerCase(Locale.ROOT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void addSpaces(StringBuilder str, int count) {
        for (int i = 0; i < count; ++i) {
            str.append(' ');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String appendPluginOptions(int maxNamesLen) {
        StringBuilder sb = new StringBuilder();
        try (JadxDecompiler decompiler = new JadxDecompiler(this.argsObj.toJadxArgs());){
            JadxPluginManager pluginManager = decompiler.getPluginManager();
            pluginManager.load(decompiler.getArgs().getPluginLoader());
            pluginManager.initAll();
            try {
                for (PluginContext context : pluginManager.getAllPluginContexts()) {
                    JadxPluginOptions options = context.getOptions();
                    if (options == null) continue;
                    this.appendPlugin(context.getPluginInfo(), context.getOptions(), sb, maxNamesLen);
                }
            }
            finally {
                pluginManager.unloadAll();
            }
        }
        if (sb.length() == 0) {
            return "";
        }
        return "\nPlugin options (-P<name>=<value>):" + String.valueOf(sb);
    }

    private boolean appendPlugin(JadxPluginInfo pluginInfo, JadxPluginOptions options, StringBuilder out, int maxNamesLen) {
        List descs = options.getOptionsDescriptions();
        if (descs.isEmpty()) {
            return false;
        }
        out.append("\n  ");
        out.append(pluginInfo.getPluginId()).append(": ").append(pluginInfo.getDescription());
        for (OptionDescription desc : descs) {
            StringBuilder opt = new StringBuilder();
            opt.append("    - ").append(desc.name());
            JCommanderWrapper.addSpaces(opt, maxNamesLen - opt.length());
            opt.append("- ").append(desc.description());
            if (!desc.values().isEmpty()) {
                opt.append(", values: ").append(desc.values());
            }
            if (desc.defaultValue() != null) {
                opt.append(", default: ").append(desc.defaultValue());
            }
            out.append("\n").append((CharSequence)opt);
        }
        return true;
    }
}

