/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli.tools;

import jadx.api.JadxArgs;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.android.TextResMapFile;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.ResTableBinaryParser;
import jadx.zip.IZipEntry;
import jadx.zip.ZipContent;
import jadx.zip.ZipReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertArscFile {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertArscFile.class);
    private static int rewritesCount;

    public static void usage() {
        LOG.info("<res-map file> <input .arsc/android.jar files or dir>");
        LOG.info("");
        LOG.info("Note: If res-map already exists - it will be merged and updated");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            ConvertArscFile.usage();
            System.exit(1);
        }
        List inputPaths = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        Path resMapFile = (Path)inputPaths.remove(0);
        List<Path> inputResFiles = ConvertArscFile.filterAndSort(FileUtils.expandDirs(inputPaths));
        HashMap<Integer, String> resMap = Files.isReadable(resMapFile) ? TextResMapFile.read((Path)resMapFile) : new HashMap<Integer, String>();
        LOG.info("Input entries count: {}", (Object)resMap.size());
        RootNode root = new RootNode(new JadxArgs());
        ZipReader zipReader = new ZipReader();
        rewritesCount = 0;
        for (Path resFile : inputResFiles) {
            ResTableBinaryParser resTableParser;
            block22: {
                resTableParser = new ResTableBinaryParser(root, true);
                if (resFile.getFileName().toString().endsWith(".jar")) {
                    ZipContent zip = zipReader.open(resFile.toFile());
                    try {
                        IZipEntry entry = zip.searchEntry("resources.arsc");
                        if (entry == null) {
                            LOG.error("Failed to load \"resources.arsc\" from {}", (Object)resFile);
                            continue;
                        }
                        try (InputStream inputStream = entry.getInputStream();){
                            resTableParser.decode(inputStream);
                            break block22;
                        }
                    }
                    finally {
                        if (zip == null) continue;
                        zip.close();
                        continue;
                    }
                }
                try (InputStream inputStream = Files.newInputStream(resFile, new OpenOption[0]);){
                    resTableParser.decode(inputStream);
                }
            }
            Map singleResMap = resTableParser.getResStorage().getResourcesNames();
            ConvertArscFile.mergeResMaps(resMap, singleResMap);
            LOG.info("{} entries count: {}, after merge: {}", new Object[]{resFile.getFileName(), singleResMap.size(), resMap.size()});
        }
        LOG.info("Output entries count: {}", (Object)resMap.size());
        LOG.info("Total rewrites count: {}", (Object)rewritesCount);
        TextResMapFile.write((Path)resMapFile, resMap);
        LOG.info("Result file size: {} B", (Object)resMapFile.toFile().length());
        LOG.info("done");
    }

    private static List<Path> filterAndSort(List<Path> inputPaths) {
        return inputPaths.stream().filter(p -> {
            String fileName = p.getFileName().toString();
            return fileName.endsWith(".arsc") || fileName.endsWith(".jar");
        }).sorted().collect(Collectors.toList());
    }

    private static void mergeResMaps(Map<Integer, String> mainResMap, Map<Integer, String> newResMap) {
        for (Map.Entry<Integer, String> entry : newResMap.entrySet()) {
            String name;
            Integer id = entry.getKey();
            String prevName = mainResMap.put(id, name = entry.getValue());
            if (prevName == null || name.equals(prevName)) continue;
            LOG.debug("Rewrite id: {} from: '{}' to: '{}'", new Object[]{Integer.toHexString(id), prevName, name});
            ++rewritesCount;
        }
    }
}

