/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import com.beust.jcommander.JCommander;
import jadx.cli.JCommanderWrapper;
import jadx.cli.commands.CommandPlugins;
import jadx.cli.commands.ICommand;
import jadx.core.utils.exceptions.JadxArgsValidateException;
import java.util.LinkedHashMap;
import java.util.Map;

public class JadxCLICommands {
    private static final Map<String, ICommand> COMMANDS_MAP = new LinkedHashMap<String, ICommand>();

    public static void register(ICommand command) {
        COMMANDS_MAP.put(command.name(), command);
    }

    public static void append(JCommander.Builder builder) {
        COMMANDS_MAP.forEach((x$0, x$1) -> builder.addCommand(x$0, x$1, new String[0]));
    }

    public static boolean process(JCommanderWrapper jcw, JCommander jc, String parsedCommand) {
        ICommand command = COMMANDS_MAP.get(parsedCommand);
        if (command == null) {
            throw new JadxArgsValidateException("Unknown command: " + parsedCommand + ". Expected one of: " + COMMANDS_MAP.keySet());
        }
        JCommander subCommander = (JCommander)jc.getCommands().get(parsedCommand);
        command.process(jcw, subCommander);
        return true;
    }

    static {
        JadxCLICommands.register(new CommandPlugins());
    }
}

