/*
 * Decompiled with CFR 0.152.
 */
package jadx.commons.app;

import dev.dirs.ProjectDirectories;
import dev.dirs.impl.Windows;
import dev.dirs.impl.WindowsPowerShell;
import dev.dirs.jni.WindowsJni;
import jadx.commons.app.JadxCommonEnv;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxCommonFiles {
    private static final Logger LOG = LoggerFactory.getLogger(JadxCommonFiles.class);
    private static final Path CONFIG_DIR;
    private static final Path CACHE_DIR;

    public static Path getConfigDir() {
        return CONFIG_DIR;
    }

    public static Path getCacheDir() {
        return CACHE_DIR;
    }

    static {
        DirsLoader loader = new DirsLoader();
        loader.init();
        CONFIG_DIR = loader.getConfigDir();
        CACHE_DIR = loader.getCacheDir();
    }

    private static final class DirsLoader {
        @Nullable
        private ProjectDirectories dirs;
        private Path configDir;
        private Path cacheDir;

        private DirsLoader() {
        }

        public void init() {
            try {
                this.configDir = this.loadEnvDir("JADX_CONFIG_DIR", pd -> pd.configDir);
                this.cacheDir = this.loadEnvDir("JADX_CACHE_DIR", pd -> pd.cacheDir);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to init common directories", e);
            }
        }

        private Path loadEnvDir(String envVar, Function<ProjectDirectories, String> dirFunc) throws IOException {
            String envDir = JadxCommonEnv.get(envVar, null);
            String dirStr = envDir != null ? envDir : dirFunc.apply(this.loadDirs());
            Path path = Path.of(dirStr, new String[0]).toAbsolutePath();
            Files.createDirectories(path, new FileAttribute[0]);
            return path;
        }

        private synchronized ProjectDirectories loadDirs() {
            ProjectDirectories currentDirs = this.dirs;
            if (currentDirs != null) {
                return currentDirs;
            }
            LOG.debug("Loading system dirs ...");
            long start = System.currentTimeMillis();
            ProjectDirectories loadedDirs = ProjectDirectories.from((String)"io.github", (String)"skylot", (String)"jadx", DirsLoader::getWinDirs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded system dirs ({}ms): config: {}, cache: {}", new Object[]{System.currentTimeMillis() - start, loadedDirs.configDir, loadedDirs.cacheDir});
            }
            this.dirs = loadedDirs;
            return loadedDirs;
        }

        private static Windows getWinDirs() {
            Windows defSup = (Windows)Windows.getDefaultSupplier().get();
            if (defSup instanceof WindowsPowerShell) {
                return new WindowsJni();
            }
            return defSup;
        }

        public Path getCacheDir() {
            return this.cacheDir;
        }

        public Path getConfigDir() {
            return this.configDir;
        }
    }
}

