/*
 * Decompiled with CFR 0.152.
 */
package sg.ndi.sp.webview.utility;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.webkit.WebView;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sg.ndi.sp.webview.utility.Constants;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ \u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lsg/ndi/sp/webview/utility/UrlHandler;", "", "()V", "getFallbackUrl", "", "uri", "Landroid/net/Uri;", "url", "handleSingpassQrCode", "", "context", "Landroid/content/Context;", "view", "Landroid/webkit/WebView;", "handleableBySingpassApp", "", "isSingpassQrCode", "library_prodRelease"})
public final class UrlHandler {
    @NotNull
    public static final UrlHandler INSTANCE = new UrlHandler();

    private UrlHandler() {
    }

    public final boolean isSingpassQrCode(@NotNull Uri uri) {
        String host;
        List pathSegments;
        String scheme;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                scheme = uri.getScheme();
                pathSegments = uri.getPathSegments();
                host = uri.getHost();
                Object object = scheme;
                boolean bl = false;
                boolean bl2 = false;
                if (object == null || StringsKt.isBlank((CharSequence)object)) break block4;
                object = pathSegments;
                bl = false;
                bl2 = false;
                if (object == null || object.isEmpty()) break block4;
                object = host;
                bl = false;
                bl2 = false;
                if (!(object == null || StringsKt.isBlank((CharSequence)object))) break block5;
            }
            return false;
        }
        if (pathSegments.size() > 1) {
            return false;
        }
        String path = (String)pathSegments.get(0);
        boolean schemeValid = StringsKt.equals((String)scheme, (String)"intent", (boolean)true) || StringsKt.equals((String)scheme, (String)"https", (boolean)true);
        boolean hostValid = StringsKt.equals((String)host, (String)"singpassmobile.sg", (boolean)true) || StringsKt.equals((String)host, (String)"www.singpassmobile.sg", (boolean)true) || StringsKt.equals((String)host, (String)"app.singpass.gov.sg", (boolean)true);
        Object[] objectArray = Constants.INSTANCE.getREQUIRED_PATH_PARAMS();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        String string = path;
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        boolean pathValid = ArraysKt.contains((Object[])objectArray, (Object)string2);
        return schemeValid && hostValid && pathValid;
    }

    public final boolean isSingpassQrCode(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return this.isSingpassQrCode(uri);
    }

    public final void handleSingpassQrCode(@NotNull Uri uri, @NotNull Context context, @Nullable WebView view) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PackageManager packageManager = context.getPackageManager();
            if (StringsKt.equals((String)uri.getScheme(), (String)"intent", (boolean)true)) {
                try {
                    Intent intent = Intent.parseUri((String)uri.toString(), (int)1);
                    ResolveInfo info = packageManager.resolveActivity(intent, 0);
                    if (info != null) {
                        context.startActivity(intent);
                        break block13;
                    }
                    WebView webView = view;
                    if (webView == null) break block13;
                    WebView webView2 = webView;
                    boolean bl = false;
                    boolean bl2 = false;
                    WebView $this$handleSingpassQrCode_u24lambda_u2d0 = webView2;
                    boolean bl3 = false;
                    String fallbackUrl = intent.getStringExtra("browser_fallback_url");
                    CharSequence charSequence = fallbackUrl;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                        $this$handleSingpassQrCode_u24lambda_u2d0.loadUrl(INSTANCE.getFallbackUrl(uri));
                        break block13;
                    }
                    $this$handleSingpassQrCode_u24lambda_u2d0.loadUrl(fallbackUrl);
                }
                catch (URISyntaxException e) {
                    WebView info = view;
                    if (info != null) {
                        info.loadUrl(this.getFallbackUrl(uri));
                    }
                    break block13;
                }
            }
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (packageManager.resolveActivity(intent, 0) != null) {
                List list = packageManager.queryIntentActivities(intent, 0);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(intent, 0)");
                List list2 = list;
                boolean spmInstalled = false;
                for (ResolveInfo info : list2) {
                    if (!StringsKt.equals((String)info.activityInfo.packageName, (String)"sg.ndi.sp", (boolean)true) || !info.activityInfo.enabled) continue;
                    spmInstalled = true;
                    break;
                }
                if (spmInstalled) {
                    intent.setPackage("sg.ndi.sp");
                    context.startActivity(intent);
                } else {
                    WebView webView = view;
                    if (webView != null) {
                        webView.loadUrl(this.getFallbackUrl(uri));
                    }
                }
            } else {
                WebView webView = view;
                if (webView != null) {
                    webView.loadUrl(this.getFallbackUrl(uri));
                }
            }
        }
    }

    public final void handleSingpassQrCode(@NotNull String url, @NotNull Context context, @Nullable WebView view) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        this.handleSingpassQrCode(uri, context, view);
    }

    public final boolean handleableBySingpassApp(@NotNull Uri uri, @NotNull WebView view) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        boolean isSingpassQrCode = this.isSingpassQrCode(uri);
        if (!isSingpassQrCode) {
            return false;
        }
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        this.handleSingpassQrCode(uri, context, view);
        return true;
    }

    @NotNull
    public final String getFallbackUrl(@NotNull Uri uri) {
        List pathSegments;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                String scheme = uri.getScheme();
                pathSegments = uri.getPathSegments();
                String host = uri.getHost();
                Object object = scheme;
                boolean bl = false;
                boolean bl2 = false;
                if (object == null || StringsKt.isBlank((CharSequence)object)) break block5;
                object = pathSegments;
                bl = false;
                bl2 = false;
                if (object == null || object.isEmpty()) break block5;
                object = host;
                bl = false;
                bl2 = false;
                if (!(object == null || StringsKt.isBlank((CharSequence)object))) break block6;
            }
            return "https://app.singpass.gov.sg/qrlogin";
        }
        if (pathSegments.size() > 1) {
            return "https://app.singpass.gov.sg/qrlogin";
        }
        String path = (String)pathSegments.get(0);
        String fallbackUrl = null;
        fallbackUrl = "https://app.singpass.gov.sg/qrlogin";
        String[] $this$forEach$iv = Constants.INSTANCE.getREQUIRED_PATH_PARAMS();
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String validPath = element$iv = stringArray[i];
            boolean bl = false;
            if (!StringsKt.equals((String)validPath, (String)path, (boolean)true)) continue;
            String string = "https://app.singpass.gov.sg/%s";
            Object[] objectArray = new Object[]{path};
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
        }
        return fallbackUrl;
    }

    @NotNull
    public final String getFallbackUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return this.getFallbackUrl(uri);
    }
}

