/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;
import com.scwang.smart.refresh.header.material.CircleImageView;
import com.scwang.smart.refresh.header.material.MaterialProgressDrawable;
import com.scwang.smart.refresh.header.material.R;
import com.scwang.smart.refresh.layout.api.RefreshComponent;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import com.scwang.smart.refresh.layout.api.RefreshKernel;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.constant.SpinnerStyle;
import com.scwang.smart.refresh.layout.simple.SimpleComponent;
import com.scwang.smart.refresh.layout.util.SmartUtil;

public class MaterialHeader
extends SimpleComponent
implements RefreshHeader {
    public static final int SIZE_LARGE = 0;
    public static final int SIZE_DEFAULT = 1;
    protected static final int CIRCLE_BG_LIGHT = -328966;
    protected static final float MAX_PROGRESS_ANGLE = 0.8f;
    @VisibleForTesting
    protected static final int CIRCLE_DIAMETER = 40;
    @VisibleForTesting
    protected static final int CIRCLE_DIAMETER_LARGE = 56;
    protected boolean mFinished;
    protected int mCircleDiameter;
    protected ImageView mCircleView;
    protected RefreshKernel mKernel;
    protected MaterialProgressDrawable mProgress;
    protected int mWaveHeight;
    protected int mHeadHeight;
    protected int mInitHeight;
    protected Path mBezierPath;
    protected Paint mBezierPaint;
    protected RefreshState mState;
    protected boolean mShowBezierWave = false;
    protected boolean mScrollableWhenRefreshing = true;

    public MaterialHeader(Context context) {
        this(context, null);
    }

    public MaterialHeader(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        int color;
        int radius;
        this.mSpinnerStyle = SpinnerStyle.MatchLayout;
        MaterialHeader thisView = this;
        MaterialHeader thisGroup = this;
        thisView.setMinimumHeight(SmartUtil.dp2px((float)100.0f));
        this.mProgress = new MaterialProgressDrawable((View)this);
        this.mProgress.setColorSchemeColors(-16737844, -48060, -10053376, -5609780, -30720);
        this.mCircleView = new CircleImageView(context, -328966);
        this.mCircleView.setImageDrawable((Drawable)this.mProgress);
        this.mCircleView.setAlpha(0.0f);
        thisGroup.addView((View)this.mCircleView);
        DisplayMetrics metrics = thisView.getResources().getDisplayMetrics();
        this.mCircleDiameter = (int)(40.0f * metrics.density);
        this.mBezierPath = new Path();
        this.mBezierPaint = new Paint();
        this.mBezierPaint.setAntiAlias(true);
        this.mBezierPaint.setStyle(Paint.Style.FILL);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MaterialHeader);
        this.mShowBezierWave = ta.getBoolean(R.styleable.MaterialHeader_srlShowBezierWave, this.mShowBezierWave);
        this.mScrollableWhenRefreshing = ta.getBoolean(R.styleable.MaterialHeader_srlScrollableWhenRefreshing, this.mScrollableWhenRefreshing);
        this.mBezierPaint.setColor(ta.getColor(R.styleable.MaterialHeader_srlPrimaryColor, -15614977));
        if (ta.hasValue(R.styleable.MaterialHeader_srlShadowRadius)) {
            radius = ta.getDimensionPixelOffset(R.styleable.MaterialHeader_srlShadowRadius, 0);
            color = ta.getColor(R.styleable.MaterialHeader_mhShadowColor, -16777216);
            this.mBezierPaint.setShadowLayer((float)radius, 0.0f, 0.0f, color);
            thisView.setLayerType(1, null);
        }
        this.mShowBezierWave = ta.getBoolean(R.styleable.MaterialHeader_mhShowBezierWave, this.mShowBezierWave);
        this.mScrollableWhenRefreshing = ta.getBoolean(R.styleable.MaterialHeader_mhScrollableWhenRefreshing, this.mScrollableWhenRefreshing);
        if (ta.hasValue(R.styleable.MaterialHeader_mhPrimaryColor)) {
            this.mBezierPaint.setColor(ta.getColor(R.styleable.MaterialHeader_mhPrimaryColor, -15614977));
        }
        if (ta.hasValue(R.styleable.MaterialHeader_mhShadowRadius)) {
            radius = ta.getDimensionPixelOffset(R.styleable.MaterialHeader_mhShadowRadius, 0);
            color = ta.getColor(R.styleable.MaterialHeader_mhShadowColor, -16777216);
            this.mBezierPaint.setShadowLayer((float)radius, 0.0f, 0.0f, color);
            thisView.setLayerType(1, null);
        }
        ta.recycle();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        ImageView circleView = this.mCircleView;
        circleView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mCircleDiameter, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mCircleDiameter, (int)0x40000000));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        MaterialHeader thisGroup = this;
        if (thisGroup.getChildCount() == 0) {
            return;
        }
        MaterialHeader thisView = this;
        ImageView circleView = this.mCircleView;
        int width = thisView.getMeasuredWidth();
        int circleWidth = circleView.getMeasuredWidth();
        int circleHeight = circleView.getMeasuredHeight();
        if (thisView.isInEditMode() && this.mHeadHeight > 0) {
            int circleTop = this.mHeadHeight - circleHeight / 2;
            circleView.layout(width / 2 - circleWidth / 2, circleTop, width / 2 + circleWidth / 2, circleTop + circleHeight);
            this.mProgress.showArrow(true);
            this.mProgress.setStartEndTrim(0.0f, 0.8f);
            this.mProgress.setArrowScale(1.0f);
            circleView.setAlpha(1.0f);
            circleView.setVisibility(0);
        } else {
            circleView.layout(width / 2 - circleWidth / 2, -circleHeight, width / 2 + circleWidth / 2, 0);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mShowBezierWave) {
            this.mBezierPath.reset();
            this.mBezierPath.lineTo(0.0f, (float)this.mHeadHeight);
            MaterialHeader thisView = this;
            this.mBezierPath.quadTo((float)thisView.getMeasuredWidth() / 2.0f, (float)this.mHeadHeight + (float)this.mWaveHeight * 1.9f, (float)thisView.getMeasuredWidth(), (float)this.mHeadHeight);
            this.mBezierPath.lineTo((float)thisView.getMeasuredWidth(), 0.0f);
            canvas.drawPath(this.mBezierPath, this.mBezierPaint);
        }
        super.dispatchDraw(canvas);
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        MaterialHeader thisView = this;
        if (!this.mShowBezierWave) {
            kernel.requestDefaultTranslationContentFor((RefreshComponent)this, false);
        }
        if (thisView.isInEditMode()) {
            this.mWaveHeight = this.mHeadHeight = height / 2;
        }
        this.mKernel = kernel;
        this.mInitHeight = height;
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        if (this.mState == RefreshState.Refreshing) {
            return;
        }
        if (this.mShowBezierWave) {
            this.mHeadHeight = Math.min(offset, height);
            this.mWaveHeight = Math.max(0, offset - height);
            MaterialHeader thisView = this;
            thisView.postInvalidate();
        }
        if (isDragging || !this.mProgress.isRunning() && !this.mFinished) {
            if (this.mState != RefreshState.Refreshing) {
                float originalDragPercent = 1.0f * (float)offset / (float)height;
                float dragPercent = Math.min(1.0f, Math.abs(originalDragPercent));
                float adjustedPercent = (float)Math.max((double)dragPercent - 0.4, 0.0) * 5.0f / 3.0f;
                float extraOS = Math.abs(offset) - height;
                float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, (float)height * 2.0f) / (float)height);
                float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
                float strokeStart = adjustedPercent * 0.8f;
                this.mProgress.showArrow(true);
                this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
                this.mProgress.setArrowScale(Math.min(1.0f, adjustedPercent));
                float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * 2.0f) * 0.5f;
                this.mProgress.setProgressRotation(rotation);
            }
            ImageView circleView = this.mCircleView;
            float targetY = (float)offset / 2.0f + (float)this.mCircleDiameter / 2.0f;
            circleView.setTranslationY(Math.min((float)offset, targetY));
            circleView.setAlpha(Math.min(1.0f, 4.0f * (float)offset / (float)this.mCircleDiameter));
        }
    }

    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        this.mProgress.start();
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        ImageView circleView = this.mCircleView;
        this.mState = newState;
        switch (newState) {
            case None: 
            case ReleaseToRefresh: 
            case Refreshing: {
                break;
            }
            case PullDownToRefresh: {
                this.mFinished = false;
                circleView.setVisibility(0);
                circleView.setTranslationY(0.0f);
                circleView.setScaleX(1.0f);
                circleView.setScaleY(1.0f);
            }
        }
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        ImageView circleView = this.mCircleView;
        this.mProgress.stop();
        circleView.animate().scaleX(0.0f).scaleY(0.0f);
        this.mFinished = true;
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mBezierPaint.setColor(colors[0]);
        }
    }

    public MaterialHeader setProgressBackgroundColorSchemeResource(@ColorRes int colorRes) {
        MaterialHeader thisView = this;
        Context context = thisView.getContext();
        int color = ContextCompat.getColor((Context)context, (int)colorRes);
        this.setProgressBackgroundColorSchemeColor(color);
        return this;
    }

    public MaterialHeader setProgressBackgroundColorSchemeColor(@ColorInt int color) {
        ImageView circle = this.mCircleView;
        circle.setBackgroundColor(color);
        return this;
    }

    public MaterialHeader setColorSchemeColors(int ... colors) {
        this.mProgress.setColorSchemeColors(colors);
        return this;
    }

    public MaterialHeader setColorSchemeResources(int ... colorIds) {
        MaterialHeader thisView = this;
        Context context = thisView.getContext();
        int[] colors = new int[colorIds.length];
        for (int i = 0; i < colorIds.length; ++i) {
            colors[i] = ContextCompat.getColor((Context)context, (int)colorIds[i]);
        }
        return this.setColorSchemeColors(colors);
    }

    public MaterialHeader setSize(int size) {
        if (size != 0 && size != 1) {
            return this;
        }
        MaterialHeader thisView = this;
        DisplayMetrics metrics = thisView.getResources().getDisplayMetrics();
        this.mCircleDiameter = size == 0 ? (int)(56.0f * metrics.density) : (int)(40.0f * metrics.density);
        this.mCircleView.setImageDrawable(null);
        this.mProgress.updateSizes(size);
        this.mCircleView.setImageDrawable((Drawable)this.mProgress);
        return this;
    }

    public MaterialHeader setShowBezierWave(boolean show) {
        this.mShowBezierWave = show;
        return this;
    }

    public MaterialHeader setScrollableWhenRefreshing(boolean scrollable) {
        this.mScrollableWhenRefreshing = scrollable;
        return this;
    }

    public boolean autoOpen(int duration, float dragRate, boolean animationOnly) {
        if (this.mShowBezierWave) {
            return false;
        }
        ImageView circleView = this.mCircleView;
        circleView.setAlpha(1.0f);
        circleView.setScaleX(0.0f);
        circleView.setScaleY(0.0f);
        circleView.setTranslationY((float)this.mInitHeight / 2.0f + (float)this.mCircleDiameter / 2.0f);
        circleView.animate().scaleX(1.0f).scaleY(1.0f).setDuration((long)duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)circleView, animationOnly){
            final /* synthetic */ View val$circleView;
            final /* synthetic */ boolean val$animationOnly;
            {
                this.val$circleView = view;
                this.val$animationOnly = bl;
            }

            public void onAnimationEnd(Animator animation) {
                this.val$circleView.animate().setListener(null);
                MaterialHeader.this.mProgress.start();
                MaterialHeader.this.mKernel.onAutoRefreshAnimationEnd(animation, this.val$animationOnly);
            }
        });
        return true;
    }
}

