/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.Size;
import io.github.sashirestela.slimvalidator.exception.ValidationException;
import java.util.Collection;
import java.util.Map;

public class SizeValidator
implements ConstraintValidator<Size, Object> {
    private int min;
    private int max;
    private boolean isVariableType;

    @Override
    public void initialize(Size annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
        this.isVariableType = annotation.isVariableType();
        if (this.min > this.max) {
            throw new ValidationException("In Size constraint, min must be less or equal than max.");
        }
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append("size must be");
        if (this.min > 0) {
            message.append(" at least ").append(this.min);
        }
        if (this.max < Integer.MAX_VALUE) {
            message.append(" at most ").append(this.max);
        }
        message.append(".");
        return message.toString();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        try {
            int size = this.getSize(value, this.isVariableType);
            return size >= this.min && size <= this.max;
        }
        catch (IllegalArgumentException e) {
            if (this.isVariableType) {
                return true;
            }
            throw new ValidationException("Cannot get a size from {0}.", value.getClass().getSimpleName(), null);
        }
    }

    private int getSize(Object value, boolean isVariableType) {
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (isVariableType) {
            throw new IllegalArgumentException();
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Map) {
            return ((Map)value).size();
        }
        if (value.getClass().isArray()) {
            return ((Object[])value).length;
        }
        throw new IllegalArgumentException();
    }
}

