/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.Size;
import io.github.sashirestela.slimvalidator.exception.ValidationException;
import java.util.Collection;
import java.util.Map;

public class SizeValidator
implements ConstraintValidator<Size, Object> {
    private int min;
    private int max;

    @Override
    public void initialize(Size annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        int length = this.getSize(value);
        return length >= this.min && length <= this.max;
    }

    private int getSize(Object value) {
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Map) {
            return ((Map)value).size();
        }
        if (value.getClass().isArray()) {
            return ((Object[])value).length;
        }
        throw new ValidationException("Cannot get a size from {0}.", value.getClass().getName(), null);
    }
}

