/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.embedding;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class EmbeddingRequest {
    @Required
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true, secondGroup=true)})
    private Object input;
    @Required
    private String model;
    private EncodingFormat encodingFormat;
    @Range(min=1.0)
    private Integer dimensions;
    private String user;

    @Generated
    EmbeddingRequest(Object input, String model, EncodingFormat encodingFormat, Integer dimensions, String user) {
        this.input = input;
        this.model = model;
        this.encodingFormat = encodingFormat;
        this.dimensions = dimensions;
        this.user = user;
    }

    @Generated
    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    @Generated
    public Object getInput() {
        return this.input;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public EncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    @Generated
    public Integer getDimensions() {
        return this.dimensions;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public EmbeddingRequest withEncodingFormat(EncodingFormat encodingFormat) {
        return this.encodingFormat == encodingFormat ? this : new EmbeddingRequest(this.input, this.model, encodingFormat, this.dimensions, this.user);
    }

    @Generated
    public static class EmbeddingRequestBuilder {
        @Generated
        private Object input;
        @Generated
        private String model;
        @Generated
        private EncodingFormat encodingFormat;
        @Generated
        private Integer dimensions;
        @Generated
        private String user;

        @Generated
        EmbeddingRequestBuilder() {
        }

        @Generated
        public EmbeddingRequestBuilder input(Object input) {
            this.input = input;
            return this;
        }

        @Generated
        public EmbeddingRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public EmbeddingRequestBuilder encodingFormat(EncodingFormat encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        @Generated
        public EmbeddingRequestBuilder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        @Generated
        public EmbeddingRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.input, this.model, this.encodingFormat, this.dimensions, this.user);
        }

        @Generated
        public String toString() {
            return "EmbeddingRequest.EmbeddingRequestBuilder(input=" + this.input + ", model=" + this.model + ", encodingFormat=" + this.encodingFormat + ", dimensions=" + this.dimensions + ", user=" + this.user + ")";
        }
    }

    public static enum EncodingFormat {
        FLOAT,
        BASE64;

    }
}

