/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.openai.BaseSimpleOpenAI;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta2;
import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAI
extends BaseSimpleOpenAI {
    public SimpleOpenAI(@NonNull String apiKey, String organizationId, String projectId, String baseUrl, HttpClient httpClient) {
        super(SimpleOpenAI.prepareBaseSimpleOpenAIArgs(apiKey, organizationId, projectId, baseUrl, httpClient));
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    public static BaseSimpleOpenAIArgs prepareBaseSimpleOpenAIArgs(String apiKey, String organizationId, String projectId, String baseUrl, HttpClient httpClient) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + apiKey);
        if (organizationId != null) {
            headers.put("OpenAI-Organization", organizationId);
        }
        if (projectId != null) {
            headers.put("OpenAI-Project", projectId);
        }
        return BaseSimpleOpenAIArgs.builder().baseUrl(Optional.ofNullable(baseUrl).orElse("https://api.openai.com")).headers(headers).httpClient(httpClient).build();
    }

    @Override
    public OpenAI.Audios audios() {
        if (this.audioService == null) {
            this.audioService = (OpenAI.Audios)this.cleverClient.create(OpenAI.Audios.class);
        }
        return this.audioService;
    }

    @Override
    public OpenAI.Batches batches() {
        if (this.batchService == null) {
            this.batchService = (OpenAI.Batches)this.cleverClient.create(OpenAI.Batches.class);
        }
        return this.batchService;
    }

    @Override
    public OpenAI.Completions completions() {
        if (this.completionService == null) {
            this.completionService = (OpenAI.Completions)this.cleverClient.create(OpenAI.Completions.class);
        }
        return this.completionService;
    }

    @Override
    public OpenAI.Embeddings embeddings() {
        if (this.embeddingService == null) {
            this.embeddingService = (OpenAI.Embeddings)this.cleverClient.create(OpenAI.Embeddings.class);
        }
        return this.embeddingService;
    }

    @Override
    public OpenAI.FineTunings fineTunings() {
        if (this.fineTuningService == null) {
            this.fineTuningService = (OpenAI.FineTunings)this.cleverClient.create(OpenAI.FineTunings.class);
        }
        return this.fineTuningService;
    }

    @Override
    public OpenAI.Images images() {
        if (this.imageService == null) {
            this.imageService = (OpenAI.Images)this.cleverClient.create(OpenAI.Images.class);
        }
        return this.imageService;
    }

    @Override
    public OpenAI.Models models() {
        if (this.modelService == null) {
            this.modelService = (OpenAI.Models)this.cleverClient.create(OpenAI.Models.class);
        }
        return this.modelService;
    }

    @Override
    public OpenAI.Moderations moderations() {
        if (this.moderationService == null) {
            this.moderationService = (OpenAI.Moderations)this.cleverClient.create(OpenAI.Moderations.class);
        }
        return this.moderationService;
    }

    @Override
    public OpenAI.Uploads uploads() {
        if (this.uploadService == null) {
            this.uploadService = (OpenAI.Uploads)this.cleverClient.create(OpenAI.Uploads.class);
        }
        return this.uploadService;
    }

    @Override
    public OpenAIBeta2.Assistants assistants() {
        if (this.assistantService == null) {
            this.assistantService = (OpenAIBeta2.Assistants)this.cleverClient.create(OpenAIBeta2.Assistants.class);
        }
        return this.assistantService;
    }

    @Override
    public OpenAIBeta2.Threads threads() {
        if (this.threadService == null) {
            this.threadService = (OpenAIBeta2.Threads)this.cleverClient.create(OpenAIBeta2.Threads.class);
        }
        return this.threadService;
    }

    @Override
    public OpenAIBeta2.ThreadMessages threadMessages() {
        if (this.threadMessageService == null) {
            this.threadMessageService = (OpenAIBeta2.ThreadMessages)this.cleverClient.create(OpenAIBeta2.ThreadMessages.class);
        }
        return this.threadMessageService;
    }

    @Override
    public OpenAIBeta2.ThreadRuns threadRuns() {
        if (this.threadRunService == null) {
            this.threadRunService = (OpenAIBeta2.ThreadRuns)this.cleverClient.create(OpenAIBeta2.ThreadRuns.class);
        }
        return this.threadRunService;
    }

    @Override
    public OpenAIBeta2.ThreadRunSteps threadRunSteps() {
        if (this.threadRunStepService == null) {
            this.threadRunStepService = (OpenAIBeta2.ThreadRunSteps)this.cleverClient.create(OpenAIBeta2.ThreadRunSteps.class);
        }
        return this.threadRunStepService;
    }

    @Override
    public OpenAIBeta2.VectorStores vectorStores() {
        if (this.vectorStoreService == null) {
            this.vectorStoreService = (OpenAIBeta2.VectorStores)this.cleverClient.create(OpenAIBeta2.VectorStores.class);
        }
        return this.vectorStoreService;
    }

    @Override
    public OpenAIBeta2.VectorStoreFiles vectorStoreFiles() {
        if (this.vectorStoreFileService == null) {
            this.vectorStoreFileService = (OpenAIBeta2.VectorStoreFiles)this.cleverClient.create(OpenAIBeta2.VectorStoreFiles.class);
        }
        return this.vectorStoreFileService;
    }

    @Override
    public OpenAIBeta2.VectorStoreFileBatches vectorStoreFileBatches() {
        if (this.vectorStoreFileBatchService == null) {
            this.vectorStoreFileBatchService = (OpenAIBeta2.VectorStoreFileBatches)this.cleverClient.create(OpenAIBeta2.VectorStoreFileBatches.class);
        }
        return this.vectorStoreFileBatchService;
    }

    @Generated
    public static SimpleOpenAIBuilder builder() {
        return new SimpleOpenAIBuilder();
    }

    @Generated
    public static class SimpleOpenAIBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String organizationId;
        @Generated
        private String projectId;
        @Generated
        private String baseUrl;
        @Generated
        private HttpClient httpClient;

        @Generated
        SimpleOpenAIBuilder() {
        }

        @Generated
        public SimpleOpenAIBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public SimpleOpenAI build() {
            return new SimpleOpenAI(this.apiKey, this.organizationId, this.projectId, this.baseUrl, this.httpClient);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAI.SimpleOpenAIBuilder(apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", projectId=" + this.projectId + ", baseUrl=" + this.baseUrl + ", httpClient=" + this.httpClient + ")";
        }
    }
}

