/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ChunkingStrategy;
import io.github.sashirestela.openai.domain.assistant.ToolResource;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ToolResourceFull {
    private ToolResource.CodeInterpreter codeInterpreter;
    private FileSearch fileSearch;

    ToolResourceFull(ToolResource.CodeInterpreter codeInterpreter, FileSearch fileSearch) {
        this.codeInterpreter = codeInterpreter;
        this.fileSearch = fileSearch;
    }

    public static ToolResourceFullBuilder builder() {
        return new ToolResourceFullBuilder();
    }

    public ToolResource.CodeInterpreter getCodeInterpreter() {
        return this.codeInterpreter;
    }

    public FileSearch getFileSearch() {
        return this.fileSearch;
    }

    public static class ToolResourceFullBuilder {
        private ToolResource.CodeInterpreter codeInterpreter;
        private FileSearch fileSearch;

        ToolResourceFullBuilder() {
        }

        public ToolResourceFullBuilder codeInterpreter(ToolResource.CodeInterpreter codeInterpreter) {
            this.codeInterpreter = codeInterpreter;
            return this;
        }

        public ToolResourceFullBuilder fileSearch(FileSearch fileSearch) {
            this.fileSearch = fileSearch;
            return this;
        }

        public ToolResourceFull build() {
            return new ToolResourceFull(this.codeInterpreter, this.fileSearch);
        }

        public String toString() {
            return "ToolResourceFull.ToolResourceFullBuilder(codeInterpreter=" + this.codeInterpreter + ", fileSearch=" + this.fileSearch + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileSearch
    extends ToolResource.FileSearch {
        @Size(max=1)
        private List<VectorStore> vectorStores;

        protected FileSearch(FileSearchBuilder<?, ?> b) {
            super(b);
            List<Object> vectorStores;
            switch (b.vectorStores == null ? 0 : b.vectorStores.size()) {
                case 0: {
                    vectorStores = Collections.emptyList();
                    break;
                }
                case 1: {
                    vectorStores = Collections.singletonList(b.vectorStores.get(0));
                    break;
                }
                default: {
                    vectorStores = Collections.unmodifiableList(new ArrayList<VectorStore>(b.vectorStores));
                }
            }
            this.vectorStores = vectorStores;
        }

        public static FileSearchBuilder<?, ?> builder() {
            return new FileSearchBuilderImpl();
        }

        public List<VectorStore> getVectorStores() {
            return this.vectorStores;
        }

        private static final class FileSearchBuilderImpl
        extends FileSearchBuilder<FileSearch, FileSearchBuilderImpl> {
            private FileSearchBuilderImpl() {
            }

            @Override
            protected FileSearchBuilderImpl self() {
                return this;
            }

            @Override
            public FileSearch build() {
                return new FileSearch(this);
            }
        }

        public static abstract class FileSearchBuilder<C extends FileSearch, B extends FileSearchBuilder<C, B>>
        extends ToolResource.FileSearch.FileSearchBuilder<C, B> {
            private ArrayList<VectorStore> vectorStores;

            public B vectorStore(VectorStore vectorStore) {
                if (this.vectorStores == null) {
                    this.vectorStores = new ArrayList();
                }
                this.vectorStores.add(vectorStore);
                return (B)this.self();
            }

            public B vectorStores(Collection<? extends VectorStore> vectorStores) {
                if (vectorStores == null) {
                    throw new NullPointerException("vectorStores cannot be null");
                }
                if (this.vectorStores == null) {
                    this.vectorStores = new ArrayList();
                }
                this.vectorStores.addAll(vectorStores);
                return (B)this.self();
            }

            public B clearVectorStores() {
                if (this.vectorStores != null) {
                    this.vectorStores.clear();
                }
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "ToolResourceFull.FileSearch.FileSearchBuilder(super=" + super.toString() + ", vectorStores=" + this.vectorStores + ")";
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class VectorStore {
            @Size(max=10000)
            private List<String> fileIds;
            private ChunkingStrategy chunkingStrategy;
            @Size(max=16)
            private Map<String, String> metadata;

            VectorStore(List<String> fileIds, ChunkingStrategy chunkingStrategy, Map<String, String> metadata) {
                this.fileIds = fileIds;
                this.chunkingStrategy = chunkingStrategy;
                this.metadata = metadata;
            }

            public static VectorStoreBuilder builder() {
                return new VectorStoreBuilder();
            }

            public List<String> getFileIds() {
                return this.fileIds;
            }

            public ChunkingStrategy getChunkingStrategy() {
                return this.chunkingStrategy;
            }

            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            public static class VectorStoreBuilder {
                private ArrayList<String> fileIds;
                private ChunkingStrategy chunkingStrategy;
                private Map<String, String> metadata;

                VectorStoreBuilder() {
                }

                public VectorStoreBuilder fileId(String fileId) {
                    if (this.fileIds == null) {
                        this.fileIds = new ArrayList();
                    }
                    this.fileIds.add(fileId);
                    return this;
                }

                public VectorStoreBuilder fileIds(Collection<? extends String> fileIds) {
                    if (fileIds == null) {
                        throw new NullPointerException("fileIds cannot be null");
                    }
                    if (this.fileIds == null) {
                        this.fileIds = new ArrayList();
                    }
                    this.fileIds.addAll(fileIds);
                    return this;
                }

                public VectorStoreBuilder clearFileIds() {
                    if (this.fileIds != null) {
                        this.fileIds.clear();
                    }
                    return this;
                }

                public VectorStoreBuilder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
                    this.chunkingStrategy = chunkingStrategy;
                    return this;
                }

                public VectorStoreBuilder metadata(Map<String, String> metadata) {
                    this.metadata = metadata;
                    return this;
                }

                public VectorStore build() {
                    List<String> fileIds;
                    switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                        case 0: {
                            fileIds = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            fileIds = Collections.singletonList(this.fileIds.get(0));
                            break;
                        }
                        default: {
                            fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                        }
                    }
                    return new VectorStore(fileIds, this.chunkingStrategy, this.metadata);
                }

                public String toString() {
                    return "ToolResourceFull.FileSearch.VectorStore.VectorStoreBuilder(fileIds=" + this.fileIds + ", chunkingStrategy=" + this.chunkingStrategy + ", metadata=" + this.metadata + ")";
                }
            }
        }
    }
}

