/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRequest;
import io.github.sashirestela.openai.domain.assistant.ToolResourceFull;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadRequest {
    private List<ThreadMessageRequest> messages;
    private ToolResourceFull toolResources;
    @Size(max=16)
    private Map<String, String> metadata;

    ThreadRequest(List<ThreadMessageRequest> messages, ToolResourceFull toolResources, Map<String, String> metadata) {
        this.messages = messages;
        this.toolResources = toolResources;
        this.metadata = metadata;
    }

    public static ThreadRequestBuilder builder() {
        return new ThreadRequestBuilder();
    }

    public List<ThreadMessageRequest> getMessages() {
        return this.messages;
    }

    public ToolResourceFull getToolResources() {
        return this.toolResources;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class ThreadRequestBuilder {
        private ArrayList<ThreadMessageRequest> messages;
        private ToolResourceFull toolResources;
        private Map<String, String> metadata;

        ThreadRequestBuilder() {
        }

        public ThreadRequestBuilder message(ThreadMessageRequest message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public ThreadRequestBuilder messages(Collection<? extends ThreadMessageRequest> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public ThreadRequestBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public ThreadRequestBuilder toolResources(ToolResourceFull toolResources) {
            this.toolResources = toolResources;
            return this;
        }

        public ThreadRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadRequest build() {
            List<ThreadMessageRequest> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<ThreadMessageRequest>(this.messages));
                }
            }
            return new ThreadRequest(messages, this.toolResources, this.metadata);
        }

        public String toString() {
            return "ThreadRequest.ThreadRequestBuilder(messages=" + this.messages + ", toolResources=" + this.toolResources + ", metadata=" + this.metadata + ")";
        }
    }
}

