/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.batch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.batch.EndpointType;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class BatchRequest {
    @Required
    private String inputFileId;
    @Required
    private EndpointType endpoint;
    @Required
    private CompletionWindowType completionWindow;
    @Size(max=16)
    private Map<String, String> metadata;

    BatchRequest(String inputFileId, EndpointType endpoint, CompletionWindowType completionWindow, Map<String, String> metadata) {
        this.inputFileId = inputFileId;
        this.endpoint = endpoint;
        this.completionWindow = completionWindow;
        this.metadata = metadata;
    }

    public static BatchRequestBuilder builder() {
        return new BatchRequestBuilder();
    }

    public String getInputFileId() {
        return this.inputFileId;
    }

    public EndpointType getEndpoint() {
        return this.endpoint;
    }

    public CompletionWindowType getCompletionWindow() {
        return this.completionWindow;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class BatchRequestBuilder {
        private String inputFileId;
        private EndpointType endpoint;
        private CompletionWindowType completionWindow;
        private Map<String, String> metadata;

        BatchRequestBuilder() {
        }

        public BatchRequestBuilder inputFileId(String inputFileId) {
            this.inputFileId = inputFileId;
            return this;
        }

        public BatchRequestBuilder endpoint(EndpointType endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public BatchRequestBuilder completionWindow(CompletionWindowType completionWindow) {
            this.completionWindow = completionWindow;
            return this;
        }

        public BatchRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BatchRequest build() {
            return new BatchRequest(this.inputFileId, this.endpoint, this.completionWindow, this.metadata);
        }

        public String toString() {
            return "BatchRequest.BatchRequestBuilder(inputFileId=" + this.inputFileId + ", endpoint=" + this.endpoint + ", completionWindow=" + this.completionWindow + ", metadata=" + this.metadata + ")";
        }
    }

    public static enum CompletionWindowType {
        T24H;

    }
}

