/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.realtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class RealtimeSession {
    private String id;
    private String object;
    private SecretConfig clientSecret;
    protected AudioFormatRealtime inputAudioFormat;
    private InputAudioNoiseReduction inputAudioNoiseReduction;
    protected InputAudioTranscription inputAudioTranscription;
    protected String instructions;
    @Range(min=1.0, max=4096.0, isVariableType=true)
    @ObjectType(baseClass={Integer.class, String.class})
    protected Object maxResponseOutputTokens;
    protected List<ChatRequest.Modality> modalities;
    private String model;
    protected AudioFormatRealtime outputAudioFormat;
    @Range(min=0.25, max=1.5)
    protected Double speed;
    @Range(min=0.6, max=1.2)
    protected Double temperature;
    @ObjectType(baseClass={String.class, ToolChoiceOption.class})
    protected Object toolChoice;
    protected List<ToolRealtime> tools;
    @ObjectType(baseClass={String.class, TracingConfig.class})
    protected Object tracing;
    protected TurnDetection turnDetection;
    protected VoiceRealtime voice;

    @Generated
    protected RealtimeSession(RealtimeSessionBuilder<?, ?> b) {
        List<Object> tools;
        List<Object> modalities;
        this.id = b.id;
        this.object = b.object;
        this.clientSecret = b.clientSecret;
        this.inputAudioFormat = b.inputAudioFormat;
        this.inputAudioNoiseReduction = b.inputAudioNoiseReduction;
        this.inputAudioTranscription = b.inputAudioTranscription;
        this.instructions = b.instructions;
        this.maxResponseOutputTokens = b.maxResponseOutputTokens;
        switch (b.modalities == null ? 0 : b.modalities.size()) {
            case 0: {
                modalities = Collections.emptyList();
                break;
            }
            case 1: {
                modalities = Collections.singletonList(b.modalities.get(0));
                break;
            }
            default: {
                modalities = Collections.unmodifiableList(new ArrayList<ChatRequest.Modality>(b.modalities));
            }
        }
        this.modalities = modalities;
        this.model = b.model;
        this.outputAudioFormat = b.outputAudioFormat;
        this.speed = b.speed;
        this.temperature = b.temperature;
        this.toolChoice = b.toolChoice;
        switch (b.tools == null ? 0 : b.tools.size()) {
            case 0: {
                tools = Collections.emptyList();
                break;
            }
            case 1: {
                tools = Collections.singletonList(b.tools.get(0));
                break;
            }
            default: {
                tools = Collections.unmodifiableList(new ArrayList<ToolRealtime>(b.tools));
            }
        }
        this.tools = tools;
        this.tracing = b.tracing;
        this.turnDetection = b.turnDetection;
        this.voice = b.voice;
    }

    @Generated
    public static RealtimeSessionBuilder<?, ?> builder() {
        return new RealtimeSessionBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public SecretConfig getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public AudioFormatRealtime getInputAudioFormat() {
        return this.inputAudioFormat;
    }

    @Generated
    public InputAudioNoiseReduction getInputAudioNoiseReduction() {
        return this.inputAudioNoiseReduction;
    }

    @Generated
    public InputAudioTranscription getInputAudioTranscription() {
        return this.inputAudioTranscription;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public Object getMaxResponseOutputTokens() {
        return this.maxResponseOutputTokens;
    }

    @Generated
    public List<ChatRequest.Modality> getModalities() {
        return this.modalities;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public AudioFormatRealtime getOutputAudioFormat() {
        return this.outputAudioFormat;
    }

    @Generated
    public Double getSpeed() {
        return this.speed;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public List<ToolRealtime> getTools() {
        return this.tools;
    }

    @Generated
    public Object getTracing() {
        return this.tracing;
    }

    @Generated
    public TurnDetection getTurnDetection() {
        return this.turnDetection;
    }

    @Generated
    public VoiceRealtime getVoice() {
        return this.voice;
    }

    @Generated
    public String toString() {
        return "RealtimeSession(id=" + this.getId() + ", object=" + this.getObject() + ", clientSecret=" + String.valueOf(this.getClientSecret()) + ", inputAudioFormat=" + String.valueOf((Object)this.getInputAudioFormat()) + ", inputAudioNoiseReduction=" + String.valueOf(this.getInputAudioNoiseReduction()) + ", inputAudioTranscription=" + String.valueOf(this.getInputAudioTranscription()) + ", instructions=" + this.getInstructions() + ", maxResponseOutputTokens=" + String.valueOf(this.getMaxResponseOutputTokens()) + ", modalities=" + String.valueOf(this.getModalities()) + ", model=" + this.getModel() + ", outputAudioFormat=" + String.valueOf((Object)this.getOutputAudioFormat()) + ", speed=" + this.getSpeed() + ", temperature=" + this.getTemperature() + ", toolChoice=" + String.valueOf(this.getToolChoice()) + ", tools=" + String.valueOf(this.getTools()) + ", tracing=" + String.valueOf(this.getTracing()) + ", turnDetection=" + String.valueOf(this.getTurnDetection()) + ", voice=" + String.valueOf((Object)this.getVoice()) + ")";
    }

    @Generated
    public RealtimeSession() {
    }

    @Generated
    public RealtimeSession(String id, String object, SecretConfig clientSecret, AudioFormatRealtime inputAudioFormat, InputAudioNoiseReduction inputAudioNoiseReduction, InputAudioTranscription inputAudioTranscription, String instructions, Object maxResponseOutputTokens, List<ChatRequest.Modality> modalities, String model, AudioFormatRealtime outputAudioFormat, Double speed, Double temperature, Object toolChoice, List<ToolRealtime> tools, Object tracing, TurnDetection turnDetection, VoiceRealtime voice) {
        this.id = id;
        this.object = object;
        this.clientSecret = clientSecret;
        this.inputAudioFormat = inputAudioFormat;
        this.inputAudioNoiseReduction = inputAudioNoiseReduction;
        this.inputAudioTranscription = inputAudioTranscription;
        this.instructions = instructions;
        this.maxResponseOutputTokens = maxResponseOutputTokens;
        this.modalities = modalities;
        this.model = model;
        this.outputAudioFormat = outputAudioFormat;
        this.speed = speed;
        this.temperature = temperature;
        this.toolChoice = toolChoice;
        this.tools = tools;
        this.tracing = tracing;
        this.turnDetection = turnDetection;
        this.voice = voice;
    }

    @Generated
    private static final class RealtimeSessionBuilderImpl
    extends RealtimeSessionBuilder<RealtimeSession, RealtimeSessionBuilderImpl> {
        @Generated
        private RealtimeSessionBuilderImpl() {
        }

        @Override
        @Generated
        protected RealtimeSessionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RealtimeSession build() {
            return new RealtimeSession(this);
        }
    }

    @Generated
    public static abstract class RealtimeSessionBuilder<C extends RealtimeSession, B extends RealtimeSessionBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String object;
        @Generated
        private SecretConfig clientSecret;
        @Generated
        private AudioFormatRealtime inputAudioFormat;
        @Generated
        private InputAudioNoiseReduction inputAudioNoiseReduction;
        @Generated
        private InputAudioTranscription inputAudioTranscription;
        @Generated
        private String instructions;
        @Generated
        private Object maxResponseOutputTokens;
        @Generated
        private ArrayList<ChatRequest.Modality> modalities;
        @Generated
        private String model;
        @Generated
        private AudioFormatRealtime outputAudioFormat;
        @Generated
        private Double speed;
        @Generated
        private Double temperature;
        @Generated
        private Object toolChoice;
        @Generated
        private ArrayList<ToolRealtime> tools;
        @Generated
        private Object tracing;
        @Generated
        private TurnDetection turnDetection;
        @Generated
        private VoiceRealtime voice;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B object(String object) {
            this.object = object;
            return this.self();
        }

        @Generated
        public B clientSecret(SecretConfig clientSecret) {
            this.clientSecret = clientSecret;
            return this.self();
        }

        @Generated
        public B inputAudioFormat(AudioFormatRealtime inputAudioFormat) {
            this.inputAudioFormat = inputAudioFormat;
            return this.self();
        }

        @Generated
        public B inputAudioNoiseReduction(InputAudioNoiseReduction inputAudioNoiseReduction) {
            this.inputAudioNoiseReduction = inputAudioNoiseReduction;
            return this.self();
        }

        @Generated
        public B inputAudioTranscription(InputAudioTranscription inputAudioTranscription) {
            this.inputAudioTranscription = inputAudioTranscription;
            return this.self();
        }

        @Generated
        public B instructions(String instructions) {
            this.instructions = instructions;
            return this.self();
        }

        @Generated
        public B maxResponseOutputTokens(Object maxResponseOutputTokens) {
            this.maxResponseOutputTokens = maxResponseOutputTokens;
            return this.self();
        }

        @Generated
        public B modality(ChatRequest.Modality modality) {
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.add(modality);
            return this.self();
        }

        @Generated
        public B modalities(Collection<? extends ChatRequest.Modality> modalities) {
            if (modalities == null) {
                throw new NullPointerException("modalities cannot be null");
            }
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.addAll(modalities);
            return this.self();
        }

        @Generated
        public B clearModalities() {
            if (this.modalities != null) {
                this.modalities.clear();
            }
            return this.self();
        }

        @Generated
        public B model(String model) {
            this.model = model;
            return this.self();
        }

        @Generated
        public B outputAudioFormat(AudioFormatRealtime outputAudioFormat) {
            this.outputAudioFormat = outputAudioFormat;
            return this.self();
        }

        @Generated
        public B speed(Double speed) {
            this.speed = speed;
            return this.self();
        }

        @Generated
        public B temperature(Double temperature) {
            this.temperature = temperature;
            return this.self();
        }

        @Generated
        public B toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this.self();
        }

        @Generated
        public B tool(ToolRealtime tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this.self();
        }

        @Generated
        public B tools(Collection<? extends ToolRealtime> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this.self();
        }

        @Generated
        public B clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this.self();
        }

        @Generated
        public B tracing(Object tracing) {
            this.tracing = tracing;
            return this.self();
        }

        @Generated
        public B turnDetection(TurnDetection turnDetection) {
            this.turnDetection = turnDetection;
            return this.self();
        }

        @Generated
        public B voice(VoiceRealtime voice) {
            this.voice = voice;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RealtimeSession.RealtimeSessionBuilder(id=" + this.id + ", object=" + this.object + ", clientSecret=" + String.valueOf(this.clientSecret) + ", inputAudioFormat=" + String.valueOf((Object)this.inputAudioFormat) + ", inputAudioNoiseReduction=" + String.valueOf(this.inputAudioNoiseReduction) + ", inputAudioTranscription=" + String.valueOf(this.inputAudioTranscription) + ", instructions=" + this.instructions + ", maxResponseOutputTokens=" + String.valueOf(this.maxResponseOutputTokens) + ", modalities=" + String.valueOf(this.modalities) + ", model=" + this.model + ", outputAudioFormat=" + String.valueOf((Object)this.outputAudioFormat) + ", speed=" + this.speed + ", temperature=" + this.temperature + ", toolChoice=" + String.valueOf(this.toolChoice) + ", tools=" + String.valueOf(this.tools) + ", tracing=" + String.valueOf(this.tracing) + ", turnDetection=" + String.valueOf(this.turnDetection) + ", voice=" + String.valueOf((Object)this.voice) + ")";
        }
    }

    public static class TracingConfig {
        private String workflowName;
        private String groupId;
        private Map<String, Object> metadata;

        @Generated
        public static TracingConfigBuilder builder() {
            return new TracingConfigBuilder();
        }

        @Generated
        public String getWorkflowName() {
            return this.workflowName;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.TracingConfig(workflowName=" + this.getWorkflowName() + ", groupId=" + this.getGroupId() + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
        }

        @Generated
        public TracingConfig() {
        }

        @Generated
        public TracingConfig(String workflowName, String groupId, Map<String, Object> metadata) {
            this.workflowName = workflowName;
            this.groupId = groupId;
            this.metadata = metadata;
        }

        @Generated
        public static class TracingConfigBuilder {
            @Generated
            private String workflowName;
            @Generated
            private String groupId;
            @Generated
            private Map<String, Object> metadata;

            @Generated
            TracingConfigBuilder() {
            }

            @Generated
            public TracingConfigBuilder workflowName(String workflowName) {
                this.workflowName = workflowName;
                return this;
            }

            @Generated
            public TracingConfigBuilder groupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            @Generated
            public TracingConfigBuilder metadata(Map<String, Object> metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public TracingConfig build() {
                return new TracingConfig(this.workflowName, this.groupId, this.metadata);
            }

            @Generated
            public String toString() {
                return "RealtimeSession.TracingConfig.TracingConfigBuilder(workflowName=" + this.workflowName + ", groupId=" + this.groupId + ", metadata=" + String.valueOf(this.metadata) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class SecretConfig {
        private Expiration expiresAfter;

        public static SecretConfig of(Integer seconds) {
            return new SecretConfig(new Expiration(seconds));
        }

        @Generated
        public Expiration getExpiresAfter() {
            return this.expiresAfter;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.SecretConfig(expiresAfter=" + String.valueOf(this.getExpiresAfter()) + ")";
        }

        @Generated
        public SecretConfig() {
        }

        @Generated
        private SecretConfig(Expiration expiresAfter) {
            this.expiresAfter = expiresAfter;
        }

        public static class Expiration {
            private String anchor = "created_at";
            @Range(min=10.0, max=7200.0)
            private Integer seconds;

            public Expiration(Integer seconds) {
                this.seconds = seconds;
            }

            @Generated
            public String getAnchor() {
                return this.anchor;
            }

            @Generated
            public Integer getSeconds() {
                return this.seconds;
            }

            @Generated
            public String toString() {
                return "RealtimeSession.SecretConfig.Expiration(anchor=" + this.getAnchor() + ", seconds=" + this.getSeconds() + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class InputAudioNoiseReduction {
        private NoiseReductionType type;

        public static InputAudioNoiseReduction of(NoiseReductionType type) {
            return new InputAudioNoiseReduction(type);
        }

        @Generated
        public NoiseReductionType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.InputAudioNoiseReduction(type=" + String.valueOf((Object)this.getType()) + ")";
        }

        @Generated
        public InputAudioNoiseReduction() {
        }

        @Generated
        private InputAudioNoiseReduction(NoiseReductionType type) {
            this.type = type;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ToolRealtime {
        private ToolType type;
        private String name;
        private String description;
        private JsonNode parameters;

        public static ToolRealtime of(FunctionDef function) {
            return new ToolRealtime(ToolType.FUNCTION, function.getName(), function.getDescription(), function.getSchemaConverter().convert(function.getFunctionalClass()));
        }

        @Generated
        public ToolType getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public JsonNode getParameters() {
            return this.parameters;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.ToolRealtime(type=" + String.valueOf((Object)this.getType()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + String.valueOf(this.getParameters()) + ")";
        }

        @Generated
        public ToolRealtime() {
        }

        @Generated
        private ToolRealtime(ToolType type, String name, String description, JsonNode parameters) {
            this.type = type;
            this.name = name;
            this.description = description;
            this.parameters = parameters;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class TurnDetection {
        private TurnDetectionType type;
        private EagernessType eagerness;
        @Range(min=0.0, max=1.0)
        private Double threshold;
        private Integer prefixPaddingMs;
        private Integer silenceDurationMs;
        private Boolean createReponse;
        private Boolean interruptResponse;

        @Generated
        public static TurnDetectionBuilder builder() {
            return new TurnDetectionBuilder();
        }

        @Generated
        public TurnDetectionType getType() {
            return this.type;
        }

        @Generated
        public EagernessType getEagerness() {
            return this.eagerness;
        }

        @Generated
        public Double getThreshold() {
            return this.threshold;
        }

        @Generated
        public Integer getPrefixPaddingMs() {
            return this.prefixPaddingMs;
        }

        @Generated
        public Integer getSilenceDurationMs() {
            return this.silenceDurationMs;
        }

        @Generated
        public Boolean getCreateReponse() {
            return this.createReponse;
        }

        @Generated
        public Boolean getInterruptResponse() {
            return this.interruptResponse;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.TurnDetection(type=" + String.valueOf((Object)this.getType()) + ", eagerness=" + String.valueOf((Object)this.getEagerness()) + ", threshold=" + this.getThreshold() + ", prefixPaddingMs=" + this.getPrefixPaddingMs() + ", silenceDurationMs=" + this.getSilenceDurationMs() + ", createReponse=" + this.getCreateReponse() + ", interruptResponse=" + this.getInterruptResponse() + ")";
        }

        @Generated
        public TurnDetection() {
        }

        @Generated
        public TurnDetection(TurnDetectionType type, EagernessType eagerness, Double threshold, Integer prefixPaddingMs, Integer silenceDurationMs, Boolean createReponse, Boolean interruptResponse) {
            this.type = type;
            this.eagerness = eagerness;
            this.threshold = threshold;
            this.prefixPaddingMs = prefixPaddingMs;
            this.silenceDurationMs = silenceDurationMs;
            this.createReponse = createReponse;
            this.interruptResponse = interruptResponse;
        }

        @Generated
        public static class TurnDetectionBuilder {
            @Generated
            private TurnDetectionType type;
            @Generated
            private EagernessType eagerness;
            @Generated
            private Double threshold;
            @Generated
            private Integer prefixPaddingMs;
            @Generated
            private Integer silenceDurationMs;
            @Generated
            private Boolean createReponse;
            @Generated
            private Boolean interruptResponse;

            @Generated
            TurnDetectionBuilder() {
            }

            @Generated
            public TurnDetectionBuilder type(TurnDetectionType type) {
                this.type = type;
                return this;
            }

            @Generated
            public TurnDetectionBuilder eagerness(EagernessType eagerness) {
                this.eagerness = eagerness;
                return this;
            }

            @Generated
            public TurnDetectionBuilder threshold(Double threshold) {
                this.threshold = threshold;
                return this;
            }

            @Generated
            public TurnDetectionBuilder prefixPaddingMs(Integer prefixPaddingMs) {
                this.prefixPaddingMs = prefixPaddingMs;
                return this;
            }

            @Generated
            public TurnDetectionBuilder silenceDurationMs(Integer silenceDurationMs) {
                this.silenceDurationMs = silenceDurationMs;
                return this;
            }

            @Generated
            public TurnDetectionBuilder createReponse(Boolean createReponse) {
                this.createReponse = createReponse;
                return this;
            }

            @Generated
            public TurnDetectionBuilder interruptResponse(Boolean interruptResponse) {
                this.interruptResponse = interruptResponse;
                return this;
            }

            @Generated
            public TurnDetection build() {
                return new TurnDetection(this.type, this.eagerness, this.threshold, this.prefixPaddingMs, this.silenceDurationMs, this.createReponse, this.interruptResponse);
            }

            @Generated
            public String toString() {
                return "RealtimeSession.TurnDetection.TurnDetectionBuilder(type=" + String.valueOf((Object)this.type) + ", eagerness=" + String.valueOf((Object)this.eagerness) + ", threshold=" + this.threshold + ", prefixPaddingMs=" + this.prefixPaddingMs + ", silenceDurationMs=" + this.silenceDurationMs + ", createReponse=" + this.createReponse + ", interruptResponse=" + this.interruptResponse + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class InputAudioTranscription {
        @Size(min=2, max=2)
        private String language;
        private String model;
        private String prompt;

        public static InputAudioTranscription of(String model) {
            return InputAudioTranscription.builder().model(model).build();
        }

        @Generated
        public static InputAudioTranscriptionBuilder builder() {
            return new InputAudioTranscriptionBuilder();
        }

        @Generated
        public String getLanguage() {
            return this.language;
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public String getPrompt() {
            return this.prompt;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.InputAudioTranscription(language=" + this.getLanguage() + ", model=" + this.getModel() + ", prompt=" + this.getPrompt() + ")";
        }

        @Generated
        public InputAudioTranscription() {
        }

        @Generated
        public InputAudioTranscription(String language, String model, String prompt) {
            this.language = language;
            this.model = model;
            this.prompt = prompt;
        }

        @Generated
        public static class InputAudioTranscriptionBuilder {
            @Generated
            private String language;
            @Generated
            private String model;
            @Generated
            private String prompt;

            @Generated
            InputAudioTranscriptionBuilder() {
            }

            @Generated
            public InputAudioTranscriptionBuilder language(String language) {
                this.language = language;
                return this;
            }

            @Generated
            public InputAudioTranscriptionBuilder model(String model) {
                this.model = model;
                return this;
            }

            @Generated
            public InputAudioTranscriptionBuilder prompt(String prompt) {
                this.prompt = prompt;
                return this;
            }

            @Generated
            public InputAudioTranscription build() {
                return new InputAudioTranscription(this.language, this.model, this.prompt);
            }

            @Generated
            public String toString() {
                return "RealtimeSession.InputAudioTranscription.InputAudioTranscriptionBuilder(language=" + this.language + ", model=" + this.model + ", prompt=" + this.prompt + ")";
            }
        }
    }

    public static enum EagernessType {
        LOW,
        MEDIUM,
        HIGH,
        AUTO;

    }

    public static enum TurnDetectionType {
        SERVER_VAD,
        SEMANTIC_VAD;

    }

    public static enum NoiseReductionType {
        NEAR_FIELD,
        FAR_FIELD;

    }

    public static enum AudioFormatRealtime {
        PCM16,
        G711_ULAW,
        G711_ALAW;

    }

    public static enum VoiceRealtime {
        ALLOY,
        ASH,
        BALLAD,
        CORAL,
        ECHO,
        FABLE,
        ONYX,
        NOVA,
        SAGE,
        SHIMMER,
        VERSE;

    }
}

