/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.realtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Item {
    private String id;
    private ItemType type;
    private String object;
    private String status;
    private RoleItemMessage role;
    private List<ContentItem> content;
    private String callId;
    private String name;
    private String arguments;
    private String output;

    @Generated
    public static ItemBuilder builder() {
        return new ItemBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ItemType getType() {
        return this.type;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public RoleItemMessage getRole() {
        return this.role;
    }

    @Generated
    public List<ContentItem> getContent() {
        return this.content;
    }

    @Generated
    public String getCallId() {
        return this.callId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getArguments() {
        return this.arguments;
    }

    @Generated
    public String getOutput() {
        return this.output;
    }

    @Generated
    public String toString() {
        return "Item(id=" + this.getId() + ", type=" + String.valueOf((Object)this.getType()) + ", object=" + this.getObject() + ", status=" + this.getStatus() + ", role=" + String.valueOf((Object)this.getRole()) + ", content=" + String.valueOf(this.getContent()) + ", callId=" + this.getCallId() + ", name=" + this.getName() + ", arguments=" + this.getArguments() + ", output=" + this.getOutput() + ")";
    }

    @Generated
    public Item() {
    }

    @Generated
    public Item(String id, ItemType type, String object, String status, RoleItemMessage role, List<ContentItem> content, String callId, String name, String arguments, String output) {
        this.id = id;
        this.type = type;
        this.object = object;
        this.status = status;
        this.role = role;
        this.content = content;
        this.callId = callId;
        this.name = name;
        this.arguments = arguments;
        this.output = output;
    }

    @Generated
    public static class ItemBuilder {
        @Generated
        private String id;
        @Generated
        private ItemType type;
        @Generated
        private String object;
        @Generated
        private String status;
        @Generated
        private RoleItemMessage role;
        @Generated
        private ArrayList<ContentItem> content;
        @Generated
        private String callId;
        @Generated
        private String name;
        @Generated
        private String arguments;
        @Generated
        private String output;

        @Generated
        ItemBuilder() {
        }

        @Generated
        public ItemBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ItemBuilder type(ItemType type) {
            this.type = type;
            return this;
        }

        @Generated
        public ItemBuilder object(String object) {
            this.object = object;
            return this;
        }

        @Generated
        public ItemBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public ItemBuilder role(RoleItemMessage role) {
            this.role = role;
            return this;
        }

        @Generated
        public ItemBuilder contentItem(ContentItem contentItem) {
            if (this.content == null) {
                this.content = new ArrayList();
            }
            this.content.add(contentItem);
            return this;
        }

        @Generated
        public ItemBuilder content(Collection<? extends ContentItem> content) {
            if (content == null) {
                throw new NullPointerException("content cannot be null");
            }
            if (this.content == null) {
                this.content = new ArrayList();
            }
            this.content.addAll(content);
            return this;
        }

        @Generated
        public ItemBuilder clearContent() {
            if (this.content != null) {
                this.content.clear();
            }
            return this;
        }

        @Generated
        public ItemBuilder callId(String callId) {
            this.callId = callId;
            return this;
        }

        @Generated
        public ItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ItemBuilder arguments(String arguments) {
            this.arguments = arguments;
            return this;
        }

        @Generated
        public ItemBuilder output(String output) {
            this.output = output;
            return this;
        }

        @Generated
        public Item build() {
            List<ContentItem> content;
            switch (this.content == null ? 0 : this.content.size()) {
                case 0: {
                    content = Collections.emptyList();
                    break;
                }
                case 1: {
                    content = Collections.singletonList(this.content.get(0));
                    break;
                }
                default: {
                    content = Collections.unmodifiableList(new ArrayList<ContentItem>(this.content));
                }
            }
            return new Item(this.id, this.type, this.object, this.status, this.role, content, this.callId, this.name, this.arguments, this.output);
        }

        @Generated
        public String toString() {
            return "Item.ItemBuilder(id=" + this.id + ", type=" + String.valueOf((Object)this.type) + ", object=" + this.object + ", status=" + this.status + ", role=" + String.valueOf((Object)this.role) + ", content=" + String.valueOf(this.content) + ", callId=" + this.callId + ", name=" + this.name + ", arguments=" + this.arguments + ", output=" + this.output + ")";
        }
    }

    public static class ContentItem {
        private ContentItemType type;
        private String text;
        private String id;
        private String audio;
        private String transcript;

        @Generated
        public static ContentItemBuilder builder() {
            return new ContentItemBuilder();
        }

        @Generated
        public ContentItemType getType() {
            return this.type;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getAudio() {
            return this.audio;
        }

        @Generated
        public String getTranscript() {
            return this.transcript;
        }

        @Generated
        public String toString() {
            return "Item.ContentItem(type=" + String.valueOf((Object)this.getType()) + ", text=" + this.getText() + ", id=" + this.getId() + ", audio=" + this.getAudio() + ", transcript=" + this.getTranscript() + ")";
        }

        @Generated
        public ContentItem() {
        }

        @Generated
        public ContentItem(ContentItemType type, String text, String id, String audio, String transcript) {
            this.type = type;
            this.text = text;
            this.id = id;
            this.audio = audio;
            this.transcript = transcript;
        }

        @Generated
        public static class ContentItemBuilder {
            @Generated
            private ContentItemType type;
            @Generated
            private String text;
            @Generated
            private String id;
            @Generated
            private String audio;
            @Generated
            private String transcript;

            @Generated
            ContentItemBuilder() {
            }

            @Generated
            public ContentItemBuilder type(ContentItemType type) {
                this.type = type;
                return this;
            }

            @Generated
            public ContentItemBuilder text(String text) {
                this.text = text;
                return this;
            }

            @Generated
            public ContentItemBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ContentItemBuilder audio(String audio) {
                this.audio = audio;
                return this;
            }

            @Generated
            public ContentItemBuilder transcript(String transcript) {
                this.transcript = transcript;
                return this;
            }

            @Generated
            public ContentItem build() {
                return new ContentItem(this.type, this.text, this.id, this.audio, this.transcript);
            }

            @Generated
            public String toString() {
                return "Item.ContentItem.ContentItemBuilder(type=" + String.valueOf((Object)this.type) + ", text=" + this.text + ", id=" + this.id + ", audio=" + this.audio + ", transcript=" + this.transcript + ")";
            }
        }
    }

    public static enum ContentItemType {
        INPUT_TEXT,
        INPUT_AUDIO,
        TEXT,
        AUDIO,
        ITEM_REFERENCE;

    }

    public static enum RoleItemMessage {
        SYSTEM,
        USER,
        ASSISTANT;

    }

    public static enum ItemType {
        MESSAGE,
        FUNCTION_CALL,
        FUNCTION_CALL_OUTPUT;

    }
}

