/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.List;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ClickAction.class, name="click"), @JsonSubTypes.Type(value=DoubleClickAction.class, name="double_click"), @JsonSubTypes.Type(value=DragAction.class, name="drag"), @JsonSubTypes.Type(value=KeyPressAction.class, name="keypress"), @JsonSubTypes.Type(value=MoveAction.class, name="move"), @JsonSubTypes.Type(value=ScreenshotAction.class, name="screenshot"), @JsonSubTypes.Type(value=ScrollAction.class, name="scroll"), @JsonSubTypes.Type(value=TypeAction.class, name="type"), @JsonSubTypes.Type(value=WaitAction.class, name="wait")})
public abstract class Action {
    protected ActionType type;

    @Generated
    public ActionType getType() {
        return this.type;
    }

    @Generated
    public void setType(ActionType type) {
        this.type = type;
    }

    public static enum MouseButton {
        LEFT,
        RIGHT,
        WHEEL,
        BACK,
        FORWARD;

    }

    public static enum ActionType {
        CLICK,
        DOUBLE_CLICK,
        DRAG,
        KEYPRESS,
        MOVE,
        SCREENSHOT,
        SCROLL,
        TYPE,
        WAIT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Coord {
        @Required
        private Integer x;
        @Required
        private Integer y;

        private Coord(Integer x, Integer y) {
            this.x = x;
            this.y = y;
        }

        public static Coord of(Integer x, Integer y) {
            return new Coord(x, y);
        }

        @Generated
        public Coord() {
        }

        @Generated
        public Integer getX() {
            return this.x;
        }

        @Generated
        public Integer getY() {
            return this.y;
        }

        @Generated
        public String toString() {
            return "Action.Coord(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class WaitAction
    extends Action {
        private WaitAction() {
            this.type = ActionType.WAIT;
        }

        public static WaitAction of() {
            return new WaitAction();
        }

        @Generated
        public String toString() {
            return "Action.WaitAction()";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class TypeAction
    extends Action {
        @Required
        private String text;

        private TypeAction(String text) {
            this.text = text;
            this.type = ActionType.TYPE;
        }

        public static TypeAction of(String text) {
            return new TypeAction(text);
        }

        @Generated
        public TypeAction() {
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String toString() {
            return "Action.TypeAction(text=" + this.getText() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ScrollAction
    extends Action {
        @Required
        private Integer scrollX;
        @Required
        private Integer scrollY;
        @Required
        private Integer x;
        @Required
        private Integer y;

        private ScrollAction(Integer scrollX, Integer scrollY, Integer x, Integer y) {
            this.scrollX = scrollX;
            this.scrollY = scrollY;
            this.x = x;
            this.y = y;
            this.type = ActionType.SCROLL;
        }

        public static ScrollAction of(Integer scrollX, Integer scrollY, Integer x, Integer y) {
            return new ScrollAction(scrollX, scrollY, x, y);
        }

        @Generated
        public ScrollAction() {
        }

        @Generated
        public Integer getScrollX() {
            return this.scrollX;
        }

        @Generated
        public Integer getScrollY() {
            return this.scrollY;
        }

        @Generated
        public Integer getX() {
            return this.x;
        }

        @Generated
        public Integer getY() {
            return this.y;
        }

        @Generated
        public String toString() {
            return "Action.ScrollAction(scrollX=" + this.getScrollX() + ", scrollY=" + this.getScrollY() + ", x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ScreenshotAction
    extends Action {
        private ScreenshotAction() {
            this.type = ActionType.SCREENSHOT;
        }

        public static ScreenshotAction of() {
            return new ScreenshotAction();
        }

        @Generated
        public String toString() {
            return "Action.ScreenshotAction()";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class MoveAction
    extends Action {
        @Required
        private Integer x;
        @Required
        private Integer y;

        private MoveAction(Integer x, Integer y) {
            this.x = x;
            this.y = y;
            this.type = ActionType.MOVE;
        }

        public static MoveAction of(Integer x, Integer y) {
            return new MoveAction(x, y);
        }

        @Generated
        public MoveAction() {
        }

        @Generated
        public Integer getX() {
            return this.x;
        }

        @Generated
        public Integer getY() {
            return this.y;
        }

        @Generated
        public String toString() {
            return "Action.MoveAction(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class KeyPressAction
    extends Action {
        @Required
        private List<String> keys;

        private KeyPressAction(List<String> keys) {
            this.keys = keys;
            this.type = ActionType.KEYPRESS;
        }

        public static KeyPressAction of(List<String> keys) {
            return new KeyPressAction(keys);
        }

        @Generated
        public KeyPressAction() {
        }

        @Generated
        public List<String> getKeys() {
            return this.keys;
        }

        @Generated
        public String toString() {
            return "Action.KeyPressAction(keys=" + String.valueOf(this.getKeys()) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class DragAction
    extends Action {
        @Required
        private List<Coord> path;

        private DragAction(List<Coord> path) {
            this.path = path;
            this.type = ActionType.DRAG;
        }

        public static DragAction of(List<Coord> path) {
            return new DragAction(path);
        }

        @Generated
        public DragAction() {
        }

        @Generated
        public List<Coord> getPath() {
            return this.path;
        }

        @Generated
        public String toString() {
            return "Action.DragAction(path=" + String.valueOf(this.getPath()) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class DoubleClickAction
    extends Action {
        @Required
        private Integer x;
        @Required
        private Integer y;

        private DoubleClickAction(Integer x, Integer y) {
            this.x = x;
            this.y = y;
            this.type = ActionType.DOUBLE_CLICK;
        }

        public static DoubleClickAction of(Integer x, Integer y) {
            return new DoubleClickAction(x, y);
        }

        @Generated
        public DoubleClickAction() {
        }

        @Generated
        public Integer getX() {
            return this.x;
        }

        @Generated
        public Integer getY() {
            return this.y;
        }

        @Generated
        public String toString() {
            return "Action.DoubleClickAction(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ClickAction
    extends Action {
        @Required
        private MouseButton button;
        @Required
        private Integer x;
        @Required
        private Integer y;

        private ClickAction(MouseButton button, Integer x, Integer y) {
            this.button = button;
            this.x = x;
            this.y = y;
            this.type = ActionType.CLICK;
        }

        public static ClickAction of(MouseButton button, Integer x, Integer y) {
            return new ClickAction(button, x, y);
        }

        @Generated
        public ClickAction() {
        }

        @Generated
        public MouseButton getButton() {
            return this.button;
        }

        @Generated
        public Integer getX() {
            return this.x;
        }

        @Generated
        public Integer getY() {
            return this.y;
        }

        @Generated
        public String toString() {
            return "Action.ClickAction(button=" + String.valueOf((Object)this.getButton()) + ", x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }
}

