/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.sashirestela.openai.domain.image.AbstractImageRequest;
import io.github.sashirestela.openai.domain.image.Background;
import io.github.sashirestela.openai.domain.image.Quality;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ImageRequest
extends AbstractImageRequest {
    @Required
    private String prompt;
    private Background background;
    private Moderation moderation;
    @Range(min=0.0, max=100.0)
    private Integer outputCompression;
    private OutputFormat outputFormat;
    private Quality quality;
    private Style style;

    @Generated
    protected ImageRequest(ImageRequestBuilder<?, ?> b) {
        super(b);
        this.prompt = b.prompt;
        this.background = b.background;
        this.moderation = b.moderation;
        this.outputCompression = b.outputCompression;
        this.outputFormat = b.outputFormat;
        this.quality = b.quality;
        this.style = b.style;
    }

    @Generated
    public static ImageRequestBuilder<?, ?> builder() {
        return new ImageRequestBuilderImpl();
    }

    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    @Generated
    public Background getBackground() {
        return this.background;
    }

    @Generated
    public Moderation getModeration() {
        return this.moderation;
    }

    @Generated
    public Integer getOutputCompression() {
        return this.outputCompression;
    }

    @Generated
    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @Generated
    public Quality getQuality() {
        return this.quality;
    }

    @Generated
    public Style getStyle() {
        return this.style;
    }

    @Generated
    private static final class ImageRequestBuilderImpl
    extends ImageRequestBuilder<ImageRequest, ImageRequestBuilderImpl> {
        @Generated
        private ImageRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected ImageRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ImageRequest build() {
            return new ImageRequest(this);
        }
    }

    @Generated
    public static abstract class ImageRequestBuilder<C extends ImageRequest, B extends ImageRequestBuilder<C, B>>
    extends AbstractImageRequest.AbstractImageRequestBuilder<C, B> {
        @Generated
        private String prompt;
        @Generated
        private Background background;
        @Generated
        private Moderation moderation;
        @Generated
        private Integer outputCompression;
        @Generated
        private OutputFormat outputFormat;
        @Generated
        private Quality quality;
        @Generated
        private Style style;

        @Generated
        public B prompt(String prompt) {
            this.prompt = prompt;
            return (B)this.self();
        }

        @Generated
        public B background(Background background) {
            this.background = background;
            return (B)this.self();
        }

        @Generated
        public B moderation(Moderation moderation) {
            this.moderation = moderation;
            return (B)this.self();
        }

        @Generated
        public B outputCompression(Integer outputCompression) {
            this.outputCompression = outputCompression;
            return (B)this.self();
        }

        @Generated
        public B outputFormat(OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return (B)this.self();
        }

        @Generated
        public B quality(Quality quality) {
            this.quality = quality;
            return (B)this.self();
        }

        @Generated
        public B style(Style style) {
            this.style = style;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ImageRequest.ImageRequestBuilder(super=" + super.toString() + ", prompt=" + this.prompt + ", background=" + String.valueOf((Object)this.background) + ", moderation=" + String.valueOf((Object)this.moderation) + ", outputCompression=" + this.outputCompression + ", outputFormat=" + String.valueOf((Object)this.outputFormat) + ", quality=" + String.valueOf((Object)this.quality) + ", style=" + String.valueOf((Object)this.style) + ")";
        }
    }

    public static enum OutputFormat {
        PNG,
        WEBP,
        JPEG;

    }

    public static enum Moderation {
        LOW,
        AUTO;

    }

    public static enum Style {
        VIVID,
        NATURAL;

    }
}

