/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.audio.AudioFormat;
import io.github.sashirestela.openai.common.audio.Voice;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class SpeechRequest {
    @Required
    private String model;
    @Required
    @Size(max=4096)
    private String input;
    @Required
    private Voice voice;
    private AudioFormat responseFormat;
    @Range(min=0.25, max=4.0)
    private Double speed;

    @Generated
    SpeechRequest(String model, String input, Voice voice, AudioFormat responseFormat, Double speed) {
        this.model = model;
        this.input = input;
        this.voice = voice;
        this.responseFormat = responseFormat;
        this.speed = speed;
    }

    @Generated
    public static SpeechRequestBuilder builder() {
        return new SpeechRequestBuilder();
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public Voice getVoice() {
        return this.voice;
    }

    @Generated
    public AudioFormat getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public Double getSpeed() {
        return this.speed;
    }

    @Generated
    public static class SpeechRequestBuilder {
        @Generated
        private String model;
        @Generated
        private String input;
        @Generated
        private Voice voice;
        @Generated
        private AudioFormat responseFormat;
        @Generated
        private Double speed;

        @Generated
        SpeechRequestBuilder() {
        }

        @Generated
        public SpeechRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public SpeechRequestBuilder input(String input) {
            this.input = input;
            return this;
        }

        @Generated
        public SpeechRequestBuilder voice(Voice voice) {
            this.voice = voice;
            return this;
        }

        @Generated
        public SpeechRequestBuilder responseFormat(AudioFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public SpeechRequestBuilder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        @Generated
        public SpeechRequest build() {
            return new SpeechRequest(this.model, this.input, this.voice, this.responseFormat, this.speed);
        }

        @Generated
        public String toString() {
            return "SpeechRequest.SpeechRequestBuilder(model=" + this.model + ", input=" + this.input + ", voice=" + String.valueOf((Object)this.voice) + ", responseFormat=" + String.valueOf((Object)this.responseFormat) + ", speed=" + this.speed + ")";
        }
    }
}

