/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.openai.domain.assistant.RankingOption;
import io.github.sashirestela.slimvalidator.constraints.Range;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AssistantTool
extends Tool {
    private FileSearch fileSearch;

    private AssistantTool(ToolType type, FileSearch fileSearch) {
        super(type, null);
        this.fileSearch = fileSearch;
    }

    public static AssistantTool codeInterpreter() {
        return new AssistantTool(ToolType.CODE_INTERPRETER, null);
    }

    public static AssistantTool fileSearch() {
        return new AssistantTool(ToolType.FILE_SEARCH, null);
    }

    public static AssistantTool fileSearch(Integer maxNumResults) {
        return new AssistantTool(ToolType.FILE_SEARCH, new FileSearch(maxNumResults));
    }

    public static AssistantTool fileSearch(Integer maxNumResults, RankingOption rankingOptions) {
        return new AssistantTool(ToolType.FILE_SEARCH, new FileSearch(maxNumResults, rankingOptions));
    }

    @Generated
    public AssistantTool() {
    }

    @Generated
    public FileSearch getFileSearch() {
        return this.fileSearch;
    }

    @Override
    @Generated
    public String toString() {
        return "AssistantTool(fileSearch=" + String.valueOf(this.getFileSearch()) + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileSearch {
        @Range(min=1.0, max=50.0)
        private Integer maxNumResults;
        private RankingOption rankingOptions;

        public FileSearch(Integer maxNumResults) {
            this.maxNumResults = maxNumResults;
        }

        public FileSearch(Integer maxNumResults, RankingOption rankingOptions) {
            this.maxNumResults = maxNumResults;
            this.rankingOptions = rankingOptions;
        }

        @Generated
        public FileSearch() {
        }

        @Generated
        public Integer getMaxNumResults() {
            return this.maxNumResults;
        }

        @Generated
        public RankingOption getRankingOptions() {
            return this.rankingOptions;
        }

        @Generated
        public String toString() {
            return "AssistantTool.FileSearch(maxNumResults=" + this.getMaxNumResults() + ", rankingOptions=" + String.valueOf(this.getRankingOptions()) + ")";
        }
    }
}

