/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.http.HttpResponseData;
import io.github.sashirestela.cleverclient.retry.RetryConfig;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.OpenAIProvider;
import io.github.sashirestela.openai.exception.SimpleOpenAIException;
import io.github.sashirestela.openai.service.ChatCompletionServices;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAIGeminiVertex
extends OpenAIProvider
implements ChatCompletionServices {
    public SimpleOpenAIGeminiVertex(@NonNull String baseUrl, @NonNull Supplier<String> apiKeyProvider, HttpClientAdapter clientAdapter, RetryConfig retryConfig, ObjectMapper objectMapper) {
        super(((GeminiVertexConfigurator.GeminiVertexConfiguratorBuilder)((GeminiVertexConfigurator.GeminiVertexConfiguratorBuilder)((GeminiVertexConfigurator.GeminiVertexConfiguratorBuilder)((GeminiVertexConfigurator.GeminiVertexConfiguratorBuilder)((OpenAIConfigurator.OpenAIConfiguratorBuilder)GeminiVertexConfigurator.builder().apiKeyProvider(apiKeyProvider)).baseUrl(baseUrl)).clientAdapter(clientAdapter)).retryConfig(retryConfig)).objectMapper(objectMapper)).build());
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (apiKeyProvider == null) {
            throw new NullPointerException("apiKeyProvider is marked non-null but is null");
        }
    }

    @Override
    public OpenAI.ChatCompletions chatCompletions() {
        return this.getOrCreateService(OpenAI.ChatCompletions.class);
    }

    @Generated
    public static SimpleOpenAIGeminiVertexBuilder builder() {
        return new SimpleOpenAIGeminiVertexBuilder();
    }

    @Generated
    public static class SimpleOpenAIGeminiVertexBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private Supplier<String> apiKeyProvider;
        @Generated
        private HttpClientAdapter clientAdapter;
        @Generated
        private RetryConfig retryConfig;
        @Generated
        private ObjectMapper objectMapper;

        @Generated
        SimpleOpenAIGeminiVertexBuilder() {
        }

        @Generated
        public SimpleOpenAIGeminiVertexBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiVertexBuilder apiKeyProvider(@NonNull Supplier<String> apiKeyProvider) {
            if (apiKeyProvider == null) {
                throw new NullPointerException("apiKeyProvider is marked non-null but is null");
            }
            this.apiKeyProvider = apiKeyProvider;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiVertexBuilder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiVertexBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiVertexBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiVertex build() {
            return new SimpleOpenAIGeminiVertex(this.baseUrl, this.apiKeyProvider, this.clientAdapter, this.retryConfig, this.objectMapper);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAIGeminiVertex.SimpleOpenAIGeminiVertexBuilder(baseUrl=" + this.baseUrl + ", apiKeyProvider=" + String.valueOf(this.apiKeyProvider) + ", clientAdapter=" + String.valueOf(this.clientAdapter) + ", retryConfig=" + String.valueOf(this.retryConfig) + ", objectMapper=" + String.valueOf(this.objectMapper) + ")";
        }
    }

    static class GeminiVertexConfigurator
    extends OpenAIConfigurator {
        private final Supplier<String> apiKeyProvider;

        @Override
        public ClientConfig buildConfig() {
            return ClientConfig.builder().baseUrl(this.baseUrl).headers(Map.of()).requestInterceptor(this.makeRequestInterceptor()).responseInterceptor(this.makeResponseInterceptor()).objectMapper(this.objectMapper).build();
        }

        private UnaryOperator<HttpRequestData> makeRequestInterceptor() {
            String VERSION_REGEX = "/v\\d+(\\.\\d+)?/";
            return request -> {
                String newUrl = request.getUrl().replaceFirst("/v\\d+(\\.\\d+)?/", "/");
                request.setUrl(newUrl);
                HashMap<String, CallSite> headers = new HashMap<String, CallSite>(request.getHeaders());
                headers.put("Authorization", (CallSite)((Object)("Bearer " + this.apiKeyProvider.get())));
                request.setHeaders(headers);
                return request;
            };
        }

        private UnaryOperator<HttpResponseData> makeResponseInterceptor() {
            return response -> {
                String body = response.getBody();
                if (body == null) {
                    return response;
                }
                try {
                    JsonNode messageNode;
                    JsonNode contentNode;
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode rootNode = mapper.readTree(body);
                    JsonNode choicesNode = rootNode.path("choices");
                    if (choicesNode.isArray() && !choicesNode.isEmpty() && (contentNode = (messageNode = choicesNode.get(0).path("message")).path("content")).isArray()) {
                        ((ObjectNode)messageNode).putNull("content");
                    }
                    String modifiedBody = mapper.writeValueAsString((Object)rootNode);
                    response.setBody(modifiedBody);
                }
                catch (Exception e) {
                    throw new SimpleOpenAIException("Failed to modify response", null, e);
                }
                return response;
            };
        }

        @Generated
        protected GeminiVertexConfigurator(GeminiVertexConfiguratorBuilder<?, ?> b) {
            super(b);
            this.apiKeyProvider = b.apiKeyProvider;
        }

        @Generated
        public static GeminiVertexConfiguratorBuilder<?, ?> builder() {
            return new GeminiVertexConfiguratorBuilderImpl();
        }

        @Generated
        private static final class GeminiVertexConfiguratorBuilderImpl
        extends GeminiVertexConfiguratorBuilder<GeminiVertexConfigurator, GeminiVertexConfiguratorBuilderImpl> {
            @Generated
            private GeminiVertexConfiguratorBuilderImpl() {
            }

            @Override
            @Generated
            protected GeminiVertexConfiguratorBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public GeminiVertexConfigurator build() {
                return new GeminiVertexConfigurator(this);
            }
        }

        @Generated
        public static abstract class GeminiVertexConfiguratorBuilder<C extends GeminiVertexConfigurator, B extends GeminiVertexConfiguratorBuilder<C, B>>
        extends OpenAIConfigurator.OpenAIConfiguratorBuilder<C, B> {
            @Generated
            private Supplier<String> apiKeyProvider;

            @Generated
            public B apiKeyProvider(Supplier<String> apiKeyProvider) {
                this.apiKeyProvider = apiKeyProvider;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAIGeminiVertex.GeminiVertexConfigurator.GeminiVertexConfiguratorBuilder(super=" + super.toString() + ", apiKeyProvider=" + String.valueOf(this.apiKeyProvider) + ")";
            }
        }
    }
}

