/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.realtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.realtime.BaseEvent;
import io.github.sashirestela.openai.domain.realtime.Item;
import io.github.sashirestela.openai.domain.realtime.RealtimeResponse;
import io.github.sashirestela.openai.domain.realtime.RealtimeSession;
import lombok.Generated;

public abstract class ClientEvent {
    private ClientEvent() {
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseCancel
    extends BaseEvent {
        private String responseId;

        private ResponseCancel(String eventId, String responseId) {
            this.type = "response.cancel";
            this.eventId = eventId;
            this.responseId = responseId;
        }

        public static ResponseCancel of(String responseId) {
            return new ResponseCancel(null, responseId);
        }

        public static ResponseCancel of(String eventId, String responseId) {
            return new ResponseCancel(eventId, responseId);
        }

        @Generated
        public String getResponseId() {
            return this.responseId;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.ResponseCancel(super=" + super.toString() + ", responseId=" + this.getResponseId() + ")";
        }

        @Generated
        public ResponseCancel() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseCreate
    extends BaseEvent {
        private RealtimeResponse response;

        private ResponseCreate(String eventId, RealtimeResponse response) {
            this.type = "response.create";
            this.eventId = eventId;
            this.response = response;
        }

        public static ResponseCreate of(RealtimeResponse response) {
            return new ResponseCreate(null, response);
        }

        public static ResponseCreate of(String eventId, RealtimeResponse response) {
            return new ResponseCreate(eventId, response);
        }

        @Generated
        public RealtimeResponse getResponse() {
            return this.response;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.ResponseCreate(super=" + super.toString() + ", response=" + String.valueOf(this.getResponse()) + ")";
        }

        @Generated
        public ResponseCreate() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ConversationItemDelete
    extends BaseEvent {
        private String itemId;

        private ConversationItemDelete(String eventId, String itemId) {
            this.type = "conversation.item.delete";
            this.eventId = eventId;
            this.itemId = itemId;
        }

        public static ConversationItemDelete of(String itemId) {
            return new ConversationItemDelete(null, itemId);
        }

        public static ConversationItemDelete of(String eventId, String itemId) {
            return new ConversationItemDelete(eventId, itemId);
        }

        @Generated
        public String getItemId() {
            return this.itemId;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.ConversationItemDelete(super=" + super.toString() + ", itemId=" + this.getItemId() + ")";
        }

        @Generated
        public ConversationItemDelete() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ConversationItemTruncate
    extends BaseEvent {
        private String itemId;
        private Integer contentIndex;
        private Integer audioEndMs;

        private ConversationItemTruncate(String eventId, String itemId, Integer contentIndex, Integer audioEndMs) {
            this.type = "conversation.item.truncate";
            this.eventId = eventId;
            this.itemId = itemId;
            this.contentIndex = contentIndex;
            this.audioEndMs = audioEndMs;
        }

        public static ConversationItemTruncate of(String itemId, Integer contentIndex, Integer audioEndMs) {
            return new ConversationItemTruncate(null, itemId, contentIndex, audioEndMs);
        }

        public static ConversationItemTruncate of(String eventId, String itemId, Integer contentIndex, Integer audioEndMs) {
            return new ConversationItemTruncate(eventId, itemId, contentIndex, audioEndMs);
        }

        @Generated
        public String getItemId() {
            return this.itemId;
        }

        @Generated
        public Integer getContentIndex() {
            return this.contentIndex;
        }

        @Generated
        public Integer getAudioEndMs() {
            return this.audioEndMs;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.ConversationItemTruncate(super=" + super.toString() + ", itemId=" + this.getItemId() + ", contentIndex=" + this.getContentIndex() + ", audioEndMs=" + this.getAudioEndMs() + ")";
        }

        @Generated
        public ConversationItemTruncate() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ConversationItemCreate
    extends BaseEvent {
        private String previousItemId;
        private Item item;

        private ConversationItemCreate(String eventId, String previousItemId, Item item) {
            this.type = "conversation.item.create";
            this.eventId = eventId;
            this.previousItemId = previousItemId;
            this.item = item;
        }

        public static ConversationItemCreate of(Item item) {
            return new ConversationItemCreate(null, null, item);
        }

        public static ConversationItemCreate of(String previousItemId, Item item) {
            return new ConversationItemCreate(null, previousItemId, item);
        }

        public static ConversationItemCreate of(String eventId, String previousItemId, Item item) {
            return new ConversationItemCreate(eventId, previousItemId, item);
        }

        @Generated
        public String getPreviousItemId() {
            return this.previousItemId;
        }

        @Generated
        public Item getItem() {
            return this.item;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.ConversationItemCreate(super=" + super.toString() + ", previousItemId=" + this.getPreviousItemId() + ", item=" + String.valueOf(this.getItem()) + ")";
        }

        @Generated
        public ConversationItemCreate() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class InputAudioBufferClear
    extends BaseEvent {
        private InputAudioBufferClear(String eventId) {
            this.type = "input_audio_buffer.clear";
            this.eventId = eventId;
        }

        public static InputAudioBufferClear of() {
            return new InputAudioBufferClear(null);
        }

        public static InputAudioBufferClear of(String eventId) {
            return new InputAudioBufferClear(eventId);
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.InputAudioBufferClear(super=" + super.toString() + ")";
        }

        @Generated
        public InputAudioBufferClear() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class InputAudioBufferCommit
    extends BaseEvent {
        private InputAudioBufferCommit(String eventId) {
            this.type = "input_audio_buffer.commit";
            this.eventId = eventId;
        }

        public static InputAudioBufferCommit of() {
            return new InputAudioBufferCommit(null);
        }

        public static InputAudioBufferCommit of(String eventId) {
            return new InputAudioBufferCommit(eventId);
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.InputAudioBufferCommit(super=" + super.toString() + ")";
        }

        @Generated
        public InputAudioBufferCommit() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class InputAudioBufferAppend
    extends BaseEvent {
        private String audio;

        private InputAudioBufferAppend(String eventId, String audio) {
            this.type = "input_audio_buffer.append";
            this.eventId = eventId;
            this.audio = audio;
        }

        public static InputAudioBufferAppend of(String audio) {
            return new InputAudioBufferAppend(null, audio);
        }

        public static InputAudioBufferAppend of(String eventId, String audio) {
            return new InputAudioBufferAppend(eventId, audio);
        }

        @Generated
        public String getAudio() {
            return this.audio;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.InputAudioBufferAppend(super=" + super.toString() + ", audio=" + this.getAudio() + ")";
        }

        @Generated
        public InputAudioBufferAppend() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class SessionUpdate
    extends BaseEvent {
        private RealtimeSession session;

        private SessionUpdate(String eventId, RealtimeSession session) {
            this.type = "session.update";
            this.eventId = eventId;
            this.session = session;
        }

        public static SessionUpdate of(RealtimeSession session) {
            return new SessionUpdate(null, session);
        }

        public static SessionUpdate of(String eventId, RealtimeSession session) {
            return new SessionUpdate(eventId, session);
        }

        @Generated
        public RealtimeSession getSession() {
            return this.session;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientEvent.SessionUpdate(super=" + super.toString() + ", session=" + String.valueOf(this.getSession()) + ")";
        }

        @Generated
        public SessionUpdate() {
        }
    }
}

