/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.common.tool.ToolChoice;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRequest;
import io.github.sashirestela.openai.domain.assistant.TruncationStrategy;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadRunRequest {
    @Required
    private String assistantId;
    private String model;
    private String instructions;
    private String additionalInstructions;
    private List<ThreadMessageRequest> additionalMessages;
    @Size(max=20)
    private List<Tool> tools;
    @Size(max=16)
    private Map<String, String> metadata;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private Boolean stream;
    @Range(min=256.0)
    private Integer maxPromptTokens;
    @Range(min=256.0)
    private Integer maxCompletionTokens;
    private TruncationStrategy truncationStrategy;
    @ObjectType.List(value={@ObjectType(baseClass=ToolChoiceOption.class), @ObjectType(baseClass=ToolChoice.class)})
    private Object toolChoice;
    private Boolean parallelToolCalls;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ResponseFormat.class)})
    private Object responseFormat;

    @Generated
    ThreadRunRequest(String assistantId, String model, String instructions, String additionalInstructions, List<ThreadMessageRequest> additionalMessages, List<Tool> tools, Map<String, String> metadata, Double temperature, Double topP, Boolean stream, Integer maxPromptTokens, Integer maxCompletionTokens, TruncationStrategy truncationStrategy, Object toolChoice, Boolean parallelToolCalls, Object responseFormat) {
        this.assistantId = assistantId;
        this.model = model;
        this.instructions = instructions;
        this.additionalInstructions = additionalInstructions;
        this.additionalMessages = additionalMessages;
        this.tools = tools;
        this.metadata = metadata;
        this.temperature = temperature;
        this.topP = topP;
        this.stream = stream;
        this.maxPromptTokens = maxPromptTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.truncationStrategy = truncationStrategy;
        this.toolChoice = toolChoice;
        this.parallelToolCalls = parallelToolCalls;
        this.responseFormat = responseFormat;
    }

    @Generated
    public static ThreadRunRequestBuilder builder() {
        return new ThreadRunRequestBuilder();
    }

    @Generated
    public String getAssistantId() {
        return this.assistantId;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public String getAdditionalInstructions() {
        return this.additionalInstructions;
    }

    @Generated
    public List<ThreadMessageRequest> getAdditionalMessages() {
        return this.additionalMessages;
    }

    @Generated
    public List<Tool> getTools() {
        return this.tools;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public Boolean getStream() {
        return this.stream;
    }

    @Generated
    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    @Generated
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    @Generated
    public TruncationStrategy getTruncationStrategy() {
        return this.truncationStrategy;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    @Generated
    public Object getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public ThreadRunRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ThreadRunRequest(this.assistantId, this.model, this.instructions, this.additionalInstructions, this.additionalMessages, this.tools, this.metadata, this.temperature, this.topP, stream, this.maxPromptTokens, this.maxCompletionTokens, this.truncationStrategy, this.toolChoice, this.parallelToolCalls, this.responseFormat);
    }

    @Generated
    public static class ThreadRunRequestBuilder {
        @Generated
        private String assistantId;
        @Generated
        private String model;
        @Generated
        private String instructions;
        @Generated
        private String additionalInstructions;
        @Generated
        private ArrayList<ThreadMessageRequest> additionalMessages;
        @Generated
        private ArrayList<Tool> tools;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Boolean stream;
        @Generated
        private Integer maxPromptTokens;
        @Generated
        private Integer maxCompletionTokens;
        @Generated
        private TruncationStrategy truncationStrategy;
        @Generated
        private Object toolChoice;
        @Generated
        private Boolean parallelToolCalls;
        @Generated
        private Object responseFormat;

        @Generated
        ThreadRunRequestBuilder() {
        }

        @Generated
        public ThreadRunRequestBuilder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder additionalInstructions(String additionalInstructions) {
            this.additionalInstructions = additionalInstructions;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder additionalMessage(ThreadMessageRequest additionalMessage) {
            if (this.additionalMessages == null) {
                this.additionalMessages = new ArrayList();
            }
            this.additionalMessages.add(additionalMessage);
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder additionalMessages(Collection<? extends ThreadMessageRequest> additionalMessages) {
            if (additionalMessages == null) {
                throw new NullPointerException("additionalMessages cannot be null");
            }
            if (this.additionalMessages == null) {
                this.additionalMessages = new ArrayList();
            }
            this.additionalMessages.addAll(additionalMessages);
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder clearAdditionalMessages() {
            if (this.additionalMessages != null) {
                this.additionalMessages.clear();
            }
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder tool(Tool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder tools(Collection<? extends Tool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder maxPromptTokens(Integer maxPromptTokens) {
            this.maxPromptTokens = maxPromptTokens;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder truncationStrategy(TruncationStrategy truncationStrategy) {
            this.truncationStrategy = truncationStrategy;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        @Generated
        public ThreadRunRequestBuilder responseFormat(Object responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public ThreadRunRequest build() {
            List<Tool> tools;
            List<ThreadMessageRequest> additionalMessages;
            switch (this.additionalMessages == null ? 0 : this.additionalMessages.size()) {
                case 0: {
                    additionalMessages = Collections.emptyList();
                    break;
                }
                case 1: {
                    additionalMessages = Collections.singletonList(this.additionalMessages.get(0));
                    break;
                }
                default: {
                    additionalMessages = Collections.unmodifiableList(new ArrayList<ThreadMessageRequest>(this.additionalMessages));
                }
            }
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<Tool>(this.tools));
                }
            }
            return new ThreadRunRequest(this.assistantId, this.model, this.instructions, this.additionalInstructions, additionalMessages, tools, this.metadata, this.temperature, this.topP, this.stream, this.maxPromptTokens, this.maxCompletionTokens, this.truncationStrategy, this.toolChoice, this.parallelToolCalls, this.responseFormat);
        }

        @Generated
        public String toString() {
            return "ThreadRunRequest.ThreadRunRequestBuilder(assistantId=" + this.assistantId + ", model=" + this.model + ", instructions=" + this.instructions + ", additionalInstructions=" + this.additionalInstructions + ", additionalMessages=" + String.valueOf(this.additionalMessages) + ", tools=" + String.valueOf(this.tools) + ", metadata=" + String.valueOf(this.metadata) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", stream=" + this.stream + ", maxPromptTokens=" + this.maxPromptTokens + ", maxCompletionTokens=" + this.maxCompletionTokens + ", truncationStrategy=" + String.valueOf(this.truncationStrategy) + ", toolChoice=" + String.valueOf(this.toolChoice) + ", parallelToolCalls=" + this.parallelToolCalls + ", responseFormat=" + String.valueOf(this.responseFormat) + ")";
        }
    }
}

