/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ToolResourceFull {
    private CodeInterpreter codeInterpreter;
    private FileSearch fileSearch;

    ToolResourceFull(CodeInterpreter codeInterpreter, FileSearch fileSearch) {
        this.codeInterpreter = codeInterpreter;
        this.fileSearch = fileSearch;
    }

    public static ToolResourceFullBuilder builder() {
        return new ToolResourceFullBuilder();
    }

    public CodeInterpreter getCodeInterpreter() {
        return this.codeInterpreter;
    }

    public FileSearch getFileSearch() {
        return this.fileSearch;
    }

    public static class ToolResourceFullBuilder {
        private CodeInterpreter codeInterpreter;
        private FileSearch fileSearch;

        ToolResourceFullBuilder() {
        }

        public ToolResourceFullBuilder codeInterpreter(CodeInterpreter codeInterpreter) {
            this.codeInterpreter = codeInterpreter;
            return this;
        }

        public ToolResourceFullBuilder fileSearch(FileSearch fileSearch) {
            this.fileSearch = fileSearch;
            return this;
        }

        public ToolResourceFull build() {
            return new ToolResourceFull(this.codeInterpreter, this.fileSearch);
        }

        public String toString() {
            return "ToolResourceFull.ToolResourceFullBuilder(codeInterpreter=" + this.codeInterpreter + ", fileSearch=" + this.fileSearch + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileSearch {
        @Size(max=1)
        private List<String> vectorStoreIds;
        @Size(max=1)
        private List<VectorStore> vectorStores;

        FileSearch(List<String> vectorStoreIds, List<VectorStore> vectorStores) {
            this.vectorStoreIds = vectorStoreIds;
            this.vectorStores = vectorStores;
        }

        public static FileSearchBuilder builder() {
            return new FileSearchBuilder();
        }

        public List<String> getVectorStoreIds() {
            return this.vectorStoreIds;
        }

        public List<VectorStore> getVectorStores() {
            return this.vectorStores;
        }

        public static class FileSearchBuilder {
            private ArrayList<String> vectorStoreIds;
            private ArrayList<VectorStore> vectorStores;

            FileSearchBuilder() {
            }

            public FileSearchBuilder vectorStoreId(String vectorStoreId) {
                if (this.vectorStoreIds == null) {
                    this.vectorStoreIds = new ArrayList();
                }
                this.vectorStoreIds.add(vectorStoreId);
                return this;
            }

            public FileSearchBuilder vectorStoreIds(Collection<? extends String> vectorStoreIds) {
                if (vectorStoreIds == null) {
                    throw new NullPointerException("vectorStoreIds cannot be null");
                }
                if (this.vectorStoreIds == null) {
                    this.vectorStoreIds = new ArrayList();
                }
                this.vectorStoreIds.addAll(vectorStoreIds);
                return this;
            }

            public FileSearchBuilder clearVectorStoreIds() {
                if (this.vectorStoreIds != null) {
                    this.vectorStoreIds.clear();
                }
                return this;
            }

            public FileSearchBuilder vectorStore(VectorStore vectorStore) {
                if (this.vectorStores == null) {
                    this.vectorStores = new ArrayList();
                }
                this.vectorStores.add(vectorStore);
                return this;
            }

            public FileSearchBuilder vectorStores(Collection<? extends VectorStore> vectorStores) {
                if (vectorStores == null) {
                    throw new NullPointerException("vectorStores cannot be null");
                }
                if (this.vectorStores == null) {
                    this.vectorStores = new ArrayList();
                }
                this.vectorStores.addAll(vectorStores);
                return this;
            }

            public FileSearchBuilder clearVectorStores() {
                if (this.vectorStores != null) {
                    this.vectorStores.clear();
                }
                return this;
            }

            public FileSearch build() {
                List<VectorStore> vectorStores;
                List<String> vectorStoreIds;
                switch (this.vectorStoreIds == null ? 0 : this.vectorStoreIds.size()) {
                    case 0: {
                        vectorStoreIds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        vectorStoreIds = Collections.singletonList(this.vectorStoreIds.get(0));
                        break;
                    }
                    default: {
                        vectorStoreIds = Collections.unmodifiableList(new ArrayList<String>(this.vectorStoreIds));
                    }
                }
                switch (this.vectorStores == null ? 0 : this.vectorStores.size()) {
                    case 0: {
                        vectorStores = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        vectorStores = Collections.singletonList(this.vectorStores.get(0));
                        break;
                    }
                    default: {
                        vectorStores = Collections.unmodifiableList(new ArrayList<VectorStore>(this.vectorStores));
                    }
                }
                return new FileSearch(vectorStoreIds, vectorStores);
            }

            public String toString() {
                return "ToolResourceFull.FileSearch.FileSearchBuilder(vectorStoreIds=" + this.vectorStoreIds + ", vectorStores=" + this.vectorStores + ")";
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class VectorStore {
            @Size(max=10000)
            private List<String> fileIds;
            @Size(max=16)
            private Map<String, String> metadata;

            VectorStore(List<String> fileIds, Map<String, String> metadata) {
                this.fileIds = fileIds;
                this.metadata = metadata;
            }

            public static VectorStoreBuilder builder() {
                return new VectorStoreBuilder();
            }

            public List<String> getFileIds() {
                return this.fileIds;
            }

            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            public static class VectorStoreBuilder {
                private ArrayList<String> fileIds;
                private Map<String, String> metadata;

                VectorStoreBuilder() {
                }

                public VectorStoreBuilder fileId(String fileId) {
                    if (this.fileIds == null) {
                        this.fileIds = new ArrayList();
                    }
                    this.fileIds.add(fileId);
                    return this;
                }

                public VectorStoreBuilder fileIds(Collection<? extends String> fileIds) {
                    if (fileIds == null) {
                        throw new NullPointerException("fileIds cannot be null");
                    }
                    if (this.fileIds == null) {
                        this.fileIds = new ArrayList();
                    }
                    this.fileIds.addAll(fileIds);
                    return this;
                }

                public VectorStoreBuilder clearFileIds() {
                    if (this.fileIds != null) {
                        this.fileIds.clear();
                    }
                    return this;
                }

                public VectorStoreBuilder metadata(Map<String, String> metadata) {
                    this.metadata = metadata;
                    return this;
                }

                public VectorStore build() {
                    List<String> fileIds;
                    switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                        case 0: {
                            fileIds = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            fileIds = Collections.singletonList(this.fileIds.get(0));
                            break;
                        }
                        default: {
                            fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                        }
                    }
                    return new VectorStore(fileIds, this.metadata);
                }

                public String toString() {
                    return "ToolResourceFull.FileSearch.VectorStore.VectorStoreBuilder(fileIds=" + this.fileIds + ", metadata=" + this.metadata + ")";
                }
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class CodeInterpreter {
        @Size(max=20)
        private List<String> fileIds;

        CodeInterpreter(List<String> fileIds) {
            this.fileIds = fileIds;
        }

        public static CodeInterpreterBuilder builder() {
            return new CodeInterpreterBuilder();
        }

        public List<String> getFileIds() {
            return this.fileIds;
        }

        public static class CodeInterpreterBuilder {
            private ArrayList<String> fileIds;

            CodeInterpreterBuilder() {
            }

            public CodeInterpreterBuilder fileId(String fileId) {
                if (this.fileIds == null) {
                    this.fileIds = new ArrayList();
                }
                this.fileIds.add(fileId);
                return this;
            }

            public CodeInterpreterBuilder fileIds(Collection<? extends String> fileIds) {
                if (fileIds == null) {
                    throw new NullPointerException("fileIds cannot be null");
                }
                if (this.fileIds == null) {
                    this.fileIds = new ArrayList();
                }
                this.fileIds.addAll(fileIds);
                return this;
            }

            public CodeInterpreterBuilder clearFileIds() {
                if (this.fileIds != null) {
                    this.fileIds.clear();
                }
                return this;
            }

            public CodeInterpreter build() {
                List<String> fileIds;
                switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                    case 0: {
                        fileIds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fileIds = Collections.singletonList(this.fileIds.get(0));
                        break;
                    }
                    default: {
                        fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                    }
                }
                return new CodeInterpreter(fileIds);
            }

            public String toString() {
                return "ToolResourceFull.CodeInterpreter.CodeInterpreterBuilder(fileIds=" + this.fileIds + ")";
            }
        }
    }
}

