/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.tool;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.slimvalidator.constraints.Required;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ToolChoice {
    @Required
    private ToolType type;
    @Required
    private FunctionName function;

    public static ToolChoice function(String name) {
        return new ToolChoice(ToolType.FUNCTION, new FunctionName(name));
    }

    private ToolChoice(ToolType type, FunctionName function) {
        this.type = type;
        this.function = function;
    }

    public ToolChoice() {
    }

    public ToolType getType() {
        return this.type;
    }

    public FunctionName getFunction() {
        return this.function;
    }

    public String toString() {
        return "ToolChoice(type=" + this.getType() + ", function=" + this.getFunction() + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FunctionName {
        @Required
        private String name;

        public FunctionName(String name) {
            this.name = name;
        }

        public FunctionName() {
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "ToolChoice.FunctionName(name=" + this.getName() + ")";
        }
    }
}

