/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.openai.common.content.ContentPart;
import io.github.sashirestela.openai.common.tool.ToolCall;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.List;
import lombok.Generated;

public abstract class ChatMessage {
    protected ChatRole role;

    @Generated
    public ChatRole getRole() {
        return this.role;
    }

    @Generated
    public void setRole(ChatRole role) {
        this.role = role;
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseMessage
    extends ChatMessage {
        private String content;
        private String reasoningContent;
        private List<ToolCall> toolCalls;
        private String refusal;
        private AudioResponse audio;

        @Generated
        public ResponseMessage() {
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public String getReasoningContent() {
            return this.reasoningContent;
        }

        @Generated
        public List<ToolCall> getToolCalls() {
            return this.toolCalls;
        }

        @Generated
        public String getRefusal() {
            return this.refusal;
        }

        @Generated
        public AudioResponse getAudio() {
            return this.audio;
        }

        @Generated
        public void setContent(String content) {
            this.content = content;
        }

        @Generated
        public void setReasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
        }

        @Generated
        public void setToolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
        }

        @Generated
        public void setRefusal(String refusal) {
            this.refusal = refusal;
        }

        @Generated
        public void setAudio(AudioResponse audio) {
            this.audio = audio;
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class AudioResponse {
            private String id;
            private Integer expiresAt;
            private String data;
            private String transcript;

            @Generated
            public AudioResponse() {
            }

            @Generated
            public String getId() {
                return this.id;
            }

            @Generated
            public Integer getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getData() {
                return this.data;
            }

            @Generated
            public String getTranscript() {
                return this.transcript;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setExpiresAt(Integer expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setData(String data) {
                this.data = data;
            }

            @Generated
            public void setTranscript(String transcript) {
                this.transcript = transcript;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ToolMessage
    extends ChatMessage {
        @Required
        private String content;
        @Required
        private String toolCallId;

        private ToolMessage(String content, String toolCallId) {
            this.role = ChatRole.TOOL;
            this.content = content;
            this.toolCallId = toolCallId;
        }

        public static ToolMessage of(String content, String toolCallId) {
            return new ToolMessage(content, toolCallId);
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public String getToolCallId() {
            return this.toolCallId;
        }

        @Generated
        public String toString() {
            return "ChatMessage.ToolMessage(content=" + this.getContent() + ", toolCallId=" + this.getToolCallId() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class AssistantMessage
    extends ChatMessage {
        @JsonInclude
        @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ContentPart.ChatContentPart.class, firstGroup=true)})
        private Object content;
        private String refusal;
        private String name;
        private Audio audio;
        private List<ToolCall> toolCalls;

        public AssistantMessage(String content, String refusal, String name, String audioId, List<ToolCall> toolCalls) {
            this.role = ChatRole.ASSISTANT;
            this.content = content;
            this.refusal = refusal;
            this.name = name;
            this.audio = CommonUtil.isNullOrEmpty((Object)audioId) ? null : new Audio(audioId);
            this.toolCalls = toolCalls;
        }

        public static AssistantMessage of(String content) {
            return AssistantMessage.builder().content(content).build();
        }

        public static AssistantMessage of(List<ToolCall> toolCalls) {
            return AssistantMessage.builder().toolCalls(toolCalls).build();
        }

        @Generated
        public static AssistantMessageBuilder builder() {
            return new AssistantMessageBuilder();
        }

        @Generated
        public Object getContent() {
            return this.content;
        }

        @Generated
        public String getRefusal() {
            return this.refusal;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Audio getAudio() {
            return this.audio;
        }

        @Generated
        public List<ToolCall> getToolCalls() {
            return this.toolCalls;
        }

        @Generated
        public String toString() {
            return "ChatMessage.AssistantMessage(content=" + this.getContent() + ", refusal=" + this.getRefusal() + ", name=" + this.getName() + ", audio=" + this.getAudio() + ", toolCalls=" + this.getToolCalls() + ")";
        }

        @Generated
        public static class AssistantMessageBuilder {
            @Generated
            private String content;
            @Generated
            private String refusal;
            @Generated
            private String name;
            @Generated
            private String audioId;
            @Generated
            private List<ToolCall> toolCalls;

            @Generated
            AssistantMessageBuilder() {
            }

            @Generated
            public AssistantMessageBuilder content(String content) {
                this.content = content;
                return this;
            }

            @Generated
            public AssistantMessageBuilder refusal(String refusal) {
                this.refusal = refusal;
                return this;
            }

            @Generated
            public AssistantMessageBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public AssistantMessageBuilder audioId(String audioId) {
                this.audioId = audioId;
                return this;
            }

            @Generated
            public AssistantMessageBuilder toolCalls(List<ToolCall> toolCalls) {
                this.toolCalls = toolCalls;
                return this;
            }

            @Generated
            public AssistantMessage build() {
                return new AssistantMessage(this.content, this.refusal, this.name, this.audioId, this.toolCalls);
            }

            @Generated
            public String toString() {
                return "ChatMessage.AssistantMessage.AssistantMessageBuilder(content=" + this.content + ", refusal=" + this.refusal + ", name=" + this.name + ", audioId=" + this.audioId + ", toolCalls=" + this.toolCalls + ")";
            }
        }

        static class Audio {
            @Required
            private String id;

            public Audio(String id) {
                this.id = id;
            }

            @Generated
            public String getId() {
                return this.id;
            }

            @Generated
            public String toString() {
                return "ChatMessage.AssistantMessage.Audio(id=" + this.getId() + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class UserMessage
    extends ChatMessage {
        @Required
        @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ContentPart.ChatContentPart.class, firstGroup=true)})
        private Object content;
        private String name;

        private UserMessage(Object content, String name) {
            this.role = ChatRole.USER;
            this.content = content;
            this.name = name;
        }

        public static UserMessage of(Object content, String name) {
            return new UserMessage(content, name);
        }

        public static UserMessage of(Object content) {
            return new UserMessage(content, null);
        }

        @Generated
        public Object getContent() {
            return this.content;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String toString() {
            return "ChatMessage.UserMessage(content=" + this.getContent() + ", name=" + this.getName() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class SystemMessage
    extends ChatMessage {
        @Required
        private String content;
        private String name;

        private SystemMessage(String content, String name) {
            this.role = ChatRole.SYSTEM;
            this.content = content;
            this.name = name;
        }

        public static SystemMessage of(String content, String name) {
            return new SystemMessage(content, name);
        }

        public static SystemMessage of(String content) {
            return new SystemMessage(content, null);
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String toString() {
            return "ChatMessage.SystemMessage(content=" + this.getContent() + ", name=" + this.getName() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class DeveloperMessage
    extends ChatMessage {
        @Required
        private String content;
        private String name;

        private DeveloperMessage(String content, String name) {
            this.role = ChatRole.DEVELOPER;
            this.content = content;
            this.name = name;
        }

        public static DeveloperMessage of(String content, String name) {
            return new DeveloperMessage(content, name);
        }

        public static DeveloperMessage of(String content) {
            return new DeveloperMessage(content, null);
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String toString() {
            return "ChatMessage.DeveloperMessage(content=" + this.getContent() + ", name=" + this.getName() + ")";
        }
    }

    public static enum ChatRole {
        DEVELOPER,
        SYSTEM,
        USER,
        ASSISTANT,
        TOOL;

    }
}

