/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.support;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import lombok.Generated;

public class GeminiAccessToken {
    private static final String GOOGLE_SERVICE_ACCOUNT_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private final GoogleCredentials credentials;

    public GeminiAccessToken(String credentialsFilePath) {
        GoogleCredentials creds;
        if (CommonUtil.isNullOrEmpty((Object)credentialsFilePath)) {
            throw new IllegalArgumentException("Credentials file path is empty");
        }
        try {
            creds = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(credentialsFilePath)).createScoped(Collections.singletonList(GOOGLE_SERVICE_ACCOUNT_SCOPE));
        }
        catch (IOException e) {
            creds = null;
        }
        this.credentials = creds;
    }

    GeminiAccessToken(GoogleCredentials credentials) {
        this.credentials = credentials;
    }

    public String get() {
        if (this.credentials == null) {
            return "";
        }
        try {
            this.credentials.refresh();
        }
        catch (IOException e) {
            return "";
        }
        if (this.credentials.getAccessToken() == null) {
            return "";
        }
        return this.credentials.getAccessToken().getTokenValue();
    }

    @Generated
    public GoogleCredentials getCredentials() {
        return this.credentials;
    }
}

