/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.CleverClient;
import io.github.sashirestela.openai.OpenAIRealtime;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.RealtimeConfig;
import io.github.sashirestela.slimvalidator.Validator;
import io.github.sashirestela.slimvalidator.exception.ConstraintViolationException;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

public abstract class OpenAIProvider {
    protected CleverClient cleverClient;
    protected OpenAIRealtime realtime;
    private Map<Class<?>, Object> serviceCache = new ConcurrentHashMap();

    protected OpenAIProvider(@NonNull OpenAIConfigurator configurator) {
        if (configurator == null) {
            throw new NullPointerException("configurator is marked non-null but is null");
        }
        ClientConfig clientConfig = configurator.buildConfig();
        HttpClient httpClient = Optional.ofNullable(clientConfig.getHttpClient()).orElse(HttpClient.newHttpClient());
        this.cleverClient = this.buildClient(clientConfig, httpClient);
        this.realtime = this.buildRealtime(clientConfig, httpClient);
    }

    protected <T> T getOrCreateService(Class<T> serviceClass) {
        return (T)this.serviceCache.computeIfAbsent(serviceClass, key -> this.cleverClient.create(serviceClass));
    }

    private CleverClient buildClient(ClientConfig clientConfig, HttpClient httpClient) {
        String END_OF_STREAM = "[DONE]";
        return CleverClient.builder().httpClient(httpClient).baseUrl(clientConfig.getBaseUrl()).headers(clientConfig.getHeaders()).requestInterceptor(clientConfig.getRequestInterceptor()).bodyInspector(this.bodyInspector()).endOfStream("[DONE]").objectMapper(Optional.ofNullable(clientConfig.getObjectMapper()).orElse(new ObjectMapper())).build();
    }

    private OpenAIRealtime buildRealtime(ClientConfig clientConfig, HttpClient httpClient) {
        RealtimeConfig realtimeConfig = clientConfig.getRealtimeConfig();
        if (realtimeConfig != null) {
            return OpenAIRealtime.builder().httpClient(httpClient).realtimeConfig(realtimeConfig).build();
        }
        return null;
    }

    private Consumer<Object> bodyInspector() {
        return body -> {
            Validator validator = new Validator();
            List violations = validator.validate(body);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        };
    }

    @Generated
    public void setCleverClient(CleverClient cleverClient) {
        this.cleverClient = cleverClient;
    }
}

