/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta2;
import io.github.sashirestela.openai.OpenAIRealtime;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.OpenAIProvider;
import io.github.sashirestela.openai.base.RealtimeConfig;
import io.github.sashirestela.openai.exception.SimpleOpenAIException;
import io.github.sashirestela.openai.service.AssistantServices;
import io.github.sashirestela.openai.service.AudioServices;
import io.github.sashirestela.openai.service.BatchServices;
import io.github.sashirestela.openai.service.ChatCompletionServices;
import io.github.sashirestela.openai.service.CompletionServices;
import io.github.sashirestela.openai.service.EmbeddingServices;
import io.github.sashirestela.openai.service.FileServices;
import io.github.sashirestela.openai.service.FineTunningServices;
import io.github.sashirestela.openai.service.ImageServices;
import io.github.sashirestela.openai.service.ModelServices;
import io.github.sashirestela.openai.service.ModerationServices;
import io.github.sashirestela.openai.service.RealtimeServices;
import io.github.sashirestela.openai.service.SessionServices;
import io.github.sashirestela.openai.service.UploadServices;
import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAI
extends OpenAIProvider
implements AssistantServices,
AudioServices,
BatchServices,
ChatCompletionServices,
CompletionServices,
EmbeddingServices,
FileServices,
FineTunningServices,
ImageServices,
ModelServices,
ModerationServices,
RealtimeServices,
SessionServices,
UploadServices {
    public SimpleOpenAI(@NonNull String apiKey, String organizationId, String projectId, String baseUrl, HttpClient httpClient, ObjectMapper objectMapper, RealtimeConfig realtimeConfig) {
        super(((StandardConfigurator.StandardConfiguratorBuilder)((StandardConfigurator.StandardConfiguratorBuilder)((StandardConfigurator.StandardConfiguratorBuilder)((StandardConfigurator.StandardConfiguratorBuilder)((OpenAIConfigurator.OpenAIConfiguratorBuilder)((StandardConfigurator.StandardConfiguratorBuilder)((StandardConfigurator.StandardConfiguratorBuilder)StandardConfigurator.builder().apiKey(apiKey)).organizationId(organizationId)).projectId(projectId)).baseUrl(baseUrl)).httpClient(httpClient)).objectMapper(objectMapper)).realtimeConfig(realtimeConfig)).build());
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    @Override
    public OpenAI.Audios audios() {
        return this.getOrCreateService(OpenAI.Audios.class);
    }

    @Override
    public OpenAI.Batches batches() {
        return this.getOrCreateService(OpenAI.Batches.class);
    }

    @Override
    public OpenAI.ChatCompletions chatCompletions() {
        return this.getOrCreateService(OpenAI.ChatCompletions.class);
    }

    @Override
    public OpenAI.Completions completions() {
        return this.getOrCreateService(OpenAI.Completions.class);
    }

    @Override
    public OpenAI.Embeddings embeddings() {
        return this.getOrCreateService(OpenAI.Embeddings.class);
    }

    @Override
    public OpenAI.Files files() {
        return this.getOrCreateService(OpenAI.Files.class);
    }

    @Override
    public OpenAI.FineTunings fineTunings() {
        return this.getOrCreateService(OpenAI.FineTunings.class);
    }

    @Override
    public OpenAI.Images images() {
        return this.getOrCreateService(OpenAI.Images.class);
    }

    @Override
    public OpenAI.Models models() {
        return this.getOrCreateService(OpenAI.Models.class);
    }

    @Override
    public OpenAI.Moderations moderations() {
        return this.getOrCreateService(OpenAI.Moderations.class);
    }

    @Override
    public OpenAI.Uploads uploads() {
        return this.getOrCreateService(OpenAI.Uploads.class);
    }

    @Override
    public OpenAI.SessionTokens sessionTokens() {
        return this.getOrCreateService(OpenAI.SessionTokens.class);
    }

    @Override
    public OpenAIBeta2.Assistants assistants() {
        return this.getOrCreateService(OpenAIBeta2.Assistants.class);
    }

    @Override
    public OpenAIBeta2.Threads threads() {
        return this.getOrCreateService(OpenAIBeta2.Threads.class);
    }

    @Override
    public OpenAIBeta2.ThreadMessages threadMessages() {
        return this.getOrCreateService(OpenAIBeta2.ThreadMessages.class);
    }

    @Override
    public OpenAIBeta2.ThreadRuns threadRuns() {
        return this.getOrCreateService(OpenAIBeta2.ThreadRuns.class);
    }

    @Override
    public OpenAIBeta2.ThreadRunSteps threadRunSteps() {
        return this.getOrCreateService(OpenAIBeta2.ThreadRunSteps.class);
    }

    @Override
    public OpenAIBeta2.VectorStores vectorStores() {
        return this.getOrCreateService(OpenAIBeta2.VectorStores.class);
    }

    @Override
    public OpenAIBeta2.VectorStoreFiles vectorStoreFiles() {
        return this.getOrCreateService(OpenAIBeta2.VectorStoreFiles.class);
    }

    @Override
    public OpenAIBeta2.VectorStoreFileBatches vectorStoreFileBatches() {
        return this.getOrCreateService(OpenAIBeta2.VectorStoreFileBatches.class);
    }

    @Override
    public OpenAIRealtime realtime() {
        return this.realtime;
    }

    @Generated
    public static SimpleOpenAIBuilder builder() {
        return new SimpleOpenAIBuilder();
    }

    @Generated
    public static class SimpleOpenAIBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String organizationId;
        @Generated
        private String projectId;
        @Generated
        private String baseUrl;
        @Generated
        private HttpClient httpClient;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private RealtimeConfig realtimeConfig;

        @Generated
        SimpleOpenAIBuilder() {
        }

        @Generated
        public SimpleOpenAIBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder realtimeConfig(RealtimeConfig realtimeConfig) {
            this.realtimeConfig = realtimeConfig;
            return this;
        }

        @Generated
        public SimpleOpenAI build() {
            return new SimpleOpenAI(this.apiKey, this.organizationId, this.projectId, this.baseUrl, this.httpClient, this.objectMapper, this.realtimeConfig);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAI.SimpleOpenAIBuilder(apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", projectId=" + this.projectId + ", baseUrl=" + this.baseUrl + ", httpClient=" + this.httpClient + ", objectMapper=" + this.objectMapper + ", realtimeConfig=" + this.realtimeConfig + ")";
        }
    }

    static class StandardConfigurator
    extends OpenAIConfigurator {
        private String organizationId;
        private String projectId;
        private RealtimeConfig realtimeConfig;

        @Override
        public ClientConfig buildConfig() {
            return ClientConfig.builder().baseUrl(Optional.ofNullable(this.baseUrl).orElse("https://api.openai.com")).headers(this.makeHeaders()).httpClient(this.httpClient).objectMapper(this.objectMapper).realtimeConfig(this.makeRealtimeConfig()).build();
        }

        private Map<String, String> makeHeaders() {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + this.apiKey);
            if (this.organizationId != null) {
                headers.put("OpenAI-Organization", this.organizationId);
            }
            if (this.projectId != null) {
                if (this.organizationId == null) {
                    throw new SimpleOpenAIException("OrganizationId should be provided if ProjectId is provided.");
                }
                headers.put("OpenAI-Project", this.projectId);
            }
            return headers;
        }

        private RealtimeConfig makeRealtimeConfig() {
            if (this.realtimeConfig == null) {
                return null;
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + this.apiKey);
            headers.put("OpenAI-Beta", "realtime=v1");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("model", this.realtimeConfig.getModel());
            return RealtimeConfig.builder().endpointUrl(Optional.ofNullable(this.realtimeConfig.getEndpointUrl()).orElse("wss://api.openai.com/v1/realtime")).headers(headers).queryParams(queryParams).build();
        }

        @Generated
        protected StandardConfigurator(StandardConfiguratorBuilder<?, ?> b) {
            super(b);
            this.organizationId = b.organizationId;
            this.projectId = b.projectId;
            this.realtimeConfig = b.realtimeConfig;
        }

        @Generated
        public static StandardConfiguratorBuilder<?, ?> builder() {
            return new StandardConfiguratorBuilderImpl();
        }

        @Generated
        private static final class StandardConfiguratorBuilderImpl
        extends StandardConfiguratorBuilder<StandardConfigurator, StandardConfiguratorBuilderImpl> {
            @Generated
            private StandardConfiguratorBuilderImpl() {
            }

            @Override
            @Generated
            protected StandardConfiguratorBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public StandardConfigurator build() {
                return new StandardConfigurator(this);
            }
        }

        @Generated
        public static abstract class StandardConfiguratorBuilder<C extends StandardConfigurator, B extends StandardConfiguratorBuilder<C, B>>
        extends OpenAIConfigurator.OpenAIConfiguratorBuilder<C, B> {
            @Generated
            private String organizationId;
            @Generated
            private String projectId;
            @Generated
            private RealtimeConfig realtimeConfig;

            @Generated
            public B organizationId(String organizationId) {
                this.organizationId = organizationId;
                return (B)this.self();
            }

            @Generated
            public B projectId(String projectId) {
                this.projectId = projectId;
                return (B)this.self();
            }

            @Generated
            public B realtimeConfig(RealtimeConfig realtimeConfig) {
                this.realtimeConfig = realtimeConfig;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAI.StandardConfigurator.StandardConfiguratorBuilder(super=" + super.toString() + ", organizationId=" + this.organizationId + ", projectId=" + this.projectId + ", realtimeConfig=" + this.realtimeConfig + ")";
            }
        }
    }
}

