/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.domain.assistant.AssistantTool;
import io.github.sashirestela.openai.domain.assistant.ToolResource;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AssistantModifyRequest {
    private String model;
    @Size(max=256)
    private String name;
    @Size(max=512)
    private String description;
    @Size(max=256000)
    private String instructions;
    @Size(max=128)
    private List<AssistantTool> tools;
    private ToolResource toolResources;
    @Size(max=16)
    private Map<String, String> metadata;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ResponseFormat.class)})
    private Object responseFormat;

    AssistantModifyRequest(String model, String name, String description, String instructions, List<AssistantTool> tools, ToolResource toolResources, Map<String, String> metadata, Double temperature, Double topP, Object responseFormat) {
        this.model = model;
        this.name = name;
        this.description = description;
        this.instructions = instructions;
        this.tools = tools;
        this.toolResources = toolResources;
        this.metadata = metadata;
        this.temperature = temperature;
        this.topP = topP;
        this.responseFormat = responseFormat;
    }

    public static AssistantModifyRequestBuilder builder() {
        return new AssistantModifyRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<AssistantTool> getTools() {
        return this.tools;
    }

    public ToolResource getToolResources() {
        return this.toolResources;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Object getResponseFormat() {
        return this.responseFormat;
    }

    public static class AssistantModifyRequestBuilder {
        private String model;
        private String name;
        private String description;
        private String instructions;
        private ArrayList<AssistantTool> tools;
        private ToolResource toolResources;
        private Map<String, String> metadata;
        private Double temperature;
        private Double topP;
        private Object responseFormat;

        AssistantModifyRequestBuilder() {
        }

        public AssistantModifyRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public AssistantModifyRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssistantModifyRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AssistantModifyRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public AssistantModifyRequestBuilder tool(AssistantTool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public AssistantModifyRequestBuilder tools(Collection<? extends AssistantTool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public AssistantModifyRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public AssistantModifyRequestBuilder toolResources(ToolResource toolResources) {
            this.toolResources = toolResources;
            return this;
        }

        public AssistantModifyRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public AssistantModifyRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AssistantModifyRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AssistantModifyRequestBuilder responseFormat(Object responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public AssistantModifyRequest build() {
            List<AssistantTool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<AssistantTool>(this.tools));
                }
            }
            return new AssistantModifyRequest(this.model, this.name, this.description, this.instructions, tools, this.toolResources, this.metadata, this.temperature, this.topP, this.responseFormat);
        }

        public String toString() {
            return "AssistantModifyRequest.AssistantModifyRequestBuilder(model=" + this.model + ", name=" + this.name + ", description=" + this.description + ", instructions=" + this.instructions + ", tools=" + this.tools + ", toolResources=" + this.toolResources + ", metadata=" + this.metadata + ", temperature=" + this.temperature + ", topP=" + this.topP + ", responseFormat=" + this.responseFormat + ")";
        }
    }
}

