/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.http.HttpRequestData;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public class BaseSimpleOpenAIArgs {
    @NonNull
    private final String baseUrl;
    private final Map<String, String> headers;
    private final HttpClient httpClient;
    private final UnaryOperator<HttpRequestData> requestInterceptor;

    BaseSimpleOpenAIArgs(@NonNull String baseUrl, Map<String, String> headers, HttpClient httpClient, UnaryOperator<HttpRequestData> requestInterceptor) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.baseUrl = baseUrl;
        this.headers = headers;
        this.httpClient = httpClient;
        this.requestInterceptor = requestInterceptor;
    }

    public static BaseSimpleOpenAIArgsBuilder builder() {
        return new BaseSimpleOpenAIArgsBuilder();
    }

    @NonNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public UnaryOperator<HttpRequestData> getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public static class BaseSimpleOpenAIArgsBuilder {
        private String baseUrl;
        private Map<String, String> headers;
        private HttpClient httpClient;
        private UnaryOperator<HttpRequestData> requestInterceptor;

        BaseSimpleOpenAIArgsBuilder() {
        }

        public BaseSimpleOpenAIArgsBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        public BaseSimpleOpenAIArgsBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public BaseSimpleOpenAIArgsBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public BaseSimpleOpenAIArgsBuilder requestInterceptor(UnaryOperator<HttpRequestData> requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        public BaseSimpleOpenAIArgs build() {
            return new BaseSimpleOpenAIArgs(this.baseUrl, this.headers, this.httpClient, this.requestInterceptor);
        }

        public String toString() {
            return "BaseSimpleOpenAIArgs.BaseSimpleOpenAIArgsBuilder(baseUrl=" + this.baseUrl + ", headers=" + this.headers + ", httpClient=" + this.httpClient + ", requestInterceptor=" + this.requestInterceptor + ")";
        }
    }
}

