/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.openai.BaseSimpleOpenAI;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public class SimpleOpenAIAzure
extends BaseSimpleOpenAI {
    public SimpleOpenAIAzure(@NonNull String apiKey, @NonNull String baseUrl, @NonNull String apiVersion, HttpClient httpClient) {
        super(SimpleOpenAIAzure.prepareBaseSimpleOpenAIArgs(apiKey, baseUrl, apiVersion, httpClient));
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (apiVersion == null) {
            throw new NullPointerException("apiVersion is marked non-null but is null");
        }
    }

    public static BaseSimpleOpenAIArgs prepareBaseSimpleOpenAIArgs(String apiKey, String baseUrl, String apiVersion, HttpClient httpClient) {
        Map<String, String> headers = Map.of("api-key", apiKey);
        UnaryOperator requestInterceptor = request -> {
            String VERSION_REGEX = "(\\/v\\d+\\.*\\d*)";
            String MODEL_REGEX = ",?\"model\":\"[^\"]*\",?";
            String EMPTY_REGEX = "\"\"";
            String QUOTED_COMMA = "\",\"";
            String MODEL_LITERAL = "model";
            Object url = request.getUrl();
            ContentType contentType = request.getContentType();
            Object body = request.getBody();
            url = (String)url + (((String)url).contains("?") ? "&" : "?") + "api-version=" + apiVersion;
            url = ((String)url).replaceFirst("(\\/v\\d+\\.*\\d*)", "");
            request.setUrl((String)url);
            if (contentType != null) {
                if (contentType.equals((Object)ContentType.APPLICATION_JSON)) {
                    String bodyJson = (String)request.getBody();
                    bodyJson = bodyJson.replaceFirst(",?\"model\":\"[^\"]*\",?", "");
                    bodyJson = bodyJson.replaceFirst("\"\"", "\",\"");
                    body = bodyJson;
                }
                if (contentType.equals((Object)ContentType.MULTIPART_FORMDATA)) {
                    Map bodyMap = (Map)request.getBody();
                    bodyMap.remove("model");
                    body = bodyMap;
                }
                request.setBody(body);
            }
            return request;
        };
        return BaseSimpleOpenAIArgs.builder().baseUrl(baseUrl).headers(headers).httpClient(httpClient).requestInterceptor(requestInterceptor).build();
    }

    public static SimpleOpenAIAzureBuilder builder() {
        return new SimpleOpenAIAzureBuilder();
    }

    public static class SimpleOpenAIAzureBuilder {
        private String apiKey;
        private String baseUrl;
        private String apiVersion;
        private HttpClient httpClient;

        SimpleOpenAIAzureBuilder() {
        }

        public SimpleOpenAIAzureBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public SimpleOpenAIAzureBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        public SimpleOpenAIAzureBuilder apiVersion(@NonNull String apiVersion) {
            if (apiVersion == null) {
                throw new NullPointerException("apiVersion is marked non-null but is null");
            }
            this.apiVersion = apiVersion;
            return this;
        }

        public SimpleOpenAIAzureBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SimpleOpenAIAzure build() {
            return new SimpleOpenAIAzure(this.apiKey, this.baseUrl, this.apiVersion, this.httpClient);
        }

        public String toString() {
            return "SimpleOpenAIAzure.SimpleOpenAIAzureBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", apiVersion=" + this.apiVersion + ", httpClient=" + this.httpClient + ")";
        }
    }
}

