/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.CleverClient;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta;
import io.github.sashirestela.slimvalidator.Validator;
import io.github.sashirestela.slimvalidator.exception.ConstraintViolationException;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;

public abstract class BaseSimpleOpenAI {
    private static final String END_OF_STREAM = "[DONE]";
    protected CleverClient cleverClient;
    protected OpenAI.ChatCompletions chatCompletionService;

    BaseSimpleOpenAI(@NonNull BaseSimpleOpenAIArgs args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        HttpClient httpClient = Optional.ofNullable(args.getHttpClient()).orElse(HttpClient.newHttpClient());
        Consumer<Object> bodyInspector = body -> {
            Validator validator = new Validator();
            List violations = validator.validate(body);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        };
        this.cleverClient = CleverClient.builder().httpClient(httpClient).baseUrl(args.getBaseUrl()).headers(args.getHeaders()).endOfStream(END_OF_STREAM).requestInterceptor(args.getRequestInterceptor()).bodyInspector(bodyInspector).build();
    }

    public OpenAI.Audios audios() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAI.ChatCompletions chatCompletions() {
        if (this.chatCompletionService == null) {
            this.chatCompletionService = (OpenAI.ChatCompletions)this.cleverClient.create(OpenAI.ChatCompletions.class);
        }
        return this.chatCompletionService;
    }

    public OpenAI.Completions completions() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAI.Embeddings embeddings() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAI.Files files() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAI.FineTunings fineTunings() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAI.Images images() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAI.Models models() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAI.Moderations moderations() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAIBeta.Assistants assistants() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OpenAIBeta.Threads threads() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setCleverClient(CleverClient cleverClient) {
        this.cleverClient = cleverClient;
    }
}

