/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.completion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.SimpleUncheckedException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class CompletionRequest {
    @NonNull
    private String model;
    @NonNull
    private Object prompt;
    private String suffix;
    private Integer maxTokens;
    private Double temperature;
    private Double topP;
    private Integer n;
    private Boolean stream;
    private Integer logprobs;
    private Boolean echo;
    private Object stop;
    private Integer seed;
    private Double presencePenalty;
    private Double frequencyPenalty;
    private Integer bestOf;
    private Map<String, Integer> logitBias;
    private String user;

    public CompletionRequest(@NonNull String model, @NonNull Object prompt, String suffix, Integer maxTokens, Double temperature, Double topP, Integer n, Boolean stream, Integer logprobs, Boolean echo, Object stop, Integer seed, Double presencePenalty, Double frequencyPenalty, Integer bestOf, Map<String, Integer> logitBias, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        if (!(prompt instanceof String || prompt instanceof List && (((List)prompt).get(0) instanceof String || ((List)prompt).get(0) instanceof Integer || ((List)prompt).get(0) instanceof List && ((List)((List)prompt).get(0)).get(0) instanceof Integer))) {
            throw new SimpleUncheckedException("The field prompt must be String or List<String> or List<Integer> or List<List<Integer>> classes.", null, null);
        }
        if (!(stop == null || stop instanceof String || stop instanceof List && ((List)stop).get(0) instanceof String && ((List)stop).size() <= 4)) {
            throw new SimpleUncheckedException("The field stop must be String or List<String> (max 4 items) classes.", null, null);
        }
        this.model = model;
        this.prompt = prompt;
        this.suffix = suffix;
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.seed = seed;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.bestOf = bestOf;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static CompletionRequestBuilder builder() {
        return new CompletionRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public Object getPrompt() {
        return this.prompt;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public Boolean getEcho() {
        return this.echo;
    }

    public Object getStop() {
        return this.stop;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public CompletionRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new CompletionRequest(this.model, this.prompt, this.suffix, this.maxTokens, this.temperature, this.topP, this.n, stream, this.logprobs, this.echo, this.stop, this.seed, this.presencePenalty, this.frequencyPenalty, this.bestOf, this.logitBias, this.user);
    }

    public static class CompletionRequestBuilder {
        private String model;
        private Object prompt;
        private String suffix;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private Integer logprobs;
        private Boolean echo;
        private Object stop;
        private Integer seed;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Integer bestOf;
        private Map<String, Integer> logitBias;
        private String user;

        CompletionRequestBuilder() {
        }

        public CompletionRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public CompletionRequestBuilder prompt(@NonNull Object prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return this;
        }

        public CompletionRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public CompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public CompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public CompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public CompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public CompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public CompletionRequestBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public CompletionRequestBuilder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public CompletionRequestBuilder stop(Object stop) {
            this.stop = stop;
            return this;
        }

        public CompletionRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public CompletionRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public CompletionRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public CompletionRequestBuilder bestOf(Integer bestOf) {
            this.bestOf = bestOf;
            return this;
        }

        public CompletionRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public CompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public CompletionRequest build() {
            return new CompletionRequest(this.model, this.prompt, this.suffix, this.maxTokens, this.temperature, this.topP, this.n, this.stream, this.logprobs, this.echo, this.stop, this.seed, this.presencePenalty, this.frequencyPenalty, this.bestOf, this.logitBias, this.user);
        }

        public String toString() {
            return "CompletionRequest.CompletionRequestBuilder(model=" + this.model + ", prompt=" + this.prompt + ", suffix=" + this.suffix + ", maxTokens=" + this.maxTokens + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", logprobs=" + this.logprobs + ", echo=" + this.echo + ", stop=" + this.stop + ", seed=" + this.seed + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", bestOf=" + this.bestOf + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }
}

