/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.moderation;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ModerationRequest {
    @NonNull
    private List<String> input;
    private String model;

    ModerationRequest(@NonNull List<String> input, String model) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
        this.model = model;
    }

    public static ModerationRequestBuilder builder() {
        return new ModerationRequestBuilder();
    }

    @NonNull
    public List<String> getInput() {
        return this.input;
    }

    public String getModel() {
        return this.model;
    }

    public static class ModerationRequestBuilder {
        private List<String> input;
        private String model;

        ModerationRequestBuilder() {
        }

        public ModerationRequestBuilder input(@NonNull List<String> input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public ModerationRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ModerationRequest build() {
            return new ModerationRequest(this.input, this.model);
        }

        public String toString() {
            return "ModerationRequest.ModerationRequestBuilder(input=" + this.input + ", model=" + this.model + ")";
        }
    }
}

