/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.image.ImageRespFmt;
import io.github.sashirestela.openai.domain.image.Size;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public abstract class AbstractImageRequest {
    protected String model;
    protected Integer n;
    protected Size size;
    protected ImageRespFmt responseFormat;
    protected String user;

    protected AbstractImageRequest(AbstractImageRequestBuilder<?, ?> b) {
        this.model = b.model;
        this.n = b.n;
        this.size = b.size;
        this.responseFormat = b.responseFormat;
        this.user = b.user;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getN() {
        return this.n;
    }

    public Size getSize() {
        return this.size;
    }

    public ImageRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public String getUser() {
        return this.user;
    }

    public static abstract class AbstractImageRequestBuilder<C extends AbstractImageRequest, B extends AbstractImageRequestBuilder<C, B>> {
        private String model;
        private Integer n;
        private Size size;
        private ImageRespFmt responseFormat;
        private String user;

        public B model(String model) {
            this.model = model;
            return this.self();
        }

        public B n(Integer n) {
            this.n = n;
            return this.self();
        }

        public B size(Size size) {
            this.size = size;
            return this.self();
        }

        public B responseFormat(ImageRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this.self();
        }

        public B user(String user) {
            this.user = user;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractImageRequest.AbstractImageRequestBuilder(model=" + this.model + ", n=" + this.n + ", size=" + this.size + ", responseFormat=" + this.responseFormat + ", user=" + this.user + ")";
        }
    }
}

