/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.SpeechRespFmt;
import io.github.sashirestela.openai.domain.audio.Voice;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AudioSpeechRequest {
    @NonNull
    private String model;
    @NonNull
    private String input;
    @NonNull
    private Voice voice;
    private SpeechRespFmt responseFormat;
    private Double speed;

    AudioSpeechRequest(@NonNull String model, @NonNull String input, @NonNull Voice voice, SpeechRespFmt responseFormat, Double speed) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (voice == null) {
            throw new NullPointerException("voice is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.voice = voice;
        this.responseFormat = responseFormat;
        this.speed = speed;
    }

    public static AudioSpeechRequestBuilder builder() {
        return new AudioSpeechRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getInput() {
        return this.input;
    }

    @NonNull
    public Voice getVoice() {
        return this.voice;
    }

    public SpeechRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public static class AudioSpeechRequestBuilder {
        private String model;
        private String input;
        private Voice voice;
        private SpeechRespFmt responseFormat;
        private Double speed;

        AudioSpeechRequestBuilder() {
        }

        public AudioSpeechRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public AudioSpeechRequestBuilder input(@NonNull String input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public AudioSpeechRequestBuilder voice(@NonNull Voice voice) {
            if (voice == null) {
                throw new NullPointerException("voice is marked non-null but is null");
            }
            this.voice = voice;
            return this;
        }

        public AudioSpeechRequestBuilder responseFormat(SpeechRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public AudioSpeechRequestBuilder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        public AudioSpeechRequest build() {
            return new AudioSpeechRequest(this.model, this.input, this.voice, this.responseFormat, this.speed);
        }

        public String toString() {
            return "AudioSpeechRequest.AudioSpeechRequestBuilder(model=" + this.model + ", input=" + this.input + ", voice=" + this.voice + ", responseFormat=" + this.responseFormat + ", speed=" + this.speed + ")";
        }
    }
}

