/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.embedding;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.embedding.EncodingFormat;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class EmbeddingRequest {
    @NonNull
    private String model;
    @NonNull
    private Object input;
    private EncodingFormat encodingFormat;
    private String user;

    public EmbeddingRequest(@NonNull String model, @NonNull Object input, EncodingFormat encodingFormat, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (!(input instanceof String || input instanceof List && (((List)input).get(0) instanceof String || ((List)input).get(0) instanceof Integer || ((List)input).get(0) instanceof List && ((List)((List)input).get(0)).get(0) instanceof Integer))) {
            throw new SimpleUncheckedException("The field input must be String or List<String> or List<Integer> or List<List<Integer>> classes.", null, null);
        }
        this.model = model;
        this.input = input;
        this.encodingFormat = encodingFormat;
        this.user = user;
    }

    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public Object getInput() {
        return this.input;
    }

    public EncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    public String getUser() {
        return this.user;
    }

    public EmbeddingRequest withEncodingFormat(EncodingFormat encodingFormat) {
        return this.encodingFormat == encodingFormat ? this : new EmbeddingRequest(this.model, this.input, encodingFormat, this.user);
    }

    public static class EmbeddingRequestBuilder {
        private String model;
        private Object input;
        private EncodingFormat encodingFormat;
        private String user;

        EmbeddingRequestBuilder() {
        }

        public EmbeddingRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public EmbeddingRequestBuilder input(@NonNull Object input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public EmbeddingRequestBuilder encodingFormat(EncodingFormat encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public EmbeddingRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.model, this.input, this.encodingFormat, this.user);
        }

        public String toString() {
            return "EmbeddingRequest.EmbeddingRequestBuilder(model=" + this.model + ", input=" + this.input + ", encodingFormat=" + this.encodingFormat + ", user=" + this.user + ")";
        }
    }
}

