/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import java.nio.file.Path;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AudioTranscribeRequest {
    @NonNull
    private Path file;
    @NonNull
    private String model;
    private String prompt;
    private Double temperature;
    private String language;
    private AudioRespFmt responseFormat;

    AudioTranscribeRequest(@NonNull Path file, @NonNull String model, String prompt, Double temperature, String language, AudioRespFmt responseFormat) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.temperature = temperature;
        this.language = language;
        this.responseFormat = responseFormat;
    }

    public static AudioTranscribeRequestBuilder builder() {
        return new AudioTranscribeRequestBuilder();
    }

    @NonNull
    public Path getFile() {
        return this.file;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public String getLanguage() {
        return this.language;
    }

    public AudioRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public AudioTranscribeRequest withResponseFormat(AudioRespFmt responseFormat) {
        return this.responseFormat == responseFormat ? this : new AudioTranscribeRequest(this.file, this.model, this.prompt, this.temperature, this.language, responseFormat);
    }

    public static class AudioTranscribeRequestBuilder {
        private Path file;
        private String model;
        private String prompt;
        private Double temperature;
        private String language;
        private AudioRespFmt responseFormat;

        AudioTranscribeRequestBuilder() {
        }

        public AudioTranscribeRequestBuilder file(@NonNull Path file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
            return this;
        }

        public AudioTranscribeRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public AudioTranscribeRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public AudioTranscribeRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AudioTranscribeRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        public AudioTranscribeRequestBuilder responseFormat(AudioRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public AudioTranscribeRequest build() {
            return new AudioTranscribeRequest(this.file, this.model, this.prompt, this.temperature, this.language, this.responseFormat);
        }

        public String toString() {
            return "AudioTranscribeRequest.AudioTranscribeRequestBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", temperature=" + this.temperature + ", language=" + this.language + ", responseFormat=" + this.responseFormat + ")";
        }
    }
}

