/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.CleverClient;
import io.github.sashirestela.openai.OpenAI;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Optional;
import lombok.NonNull;

public class SimpleOpenAI {
    private static final String OPENAI_URL_BASE = "https://api.openai.com";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ORGANIZATION_HEADER = "OpenAI-Organization";
    private static final String BEARER_AUTHORIZATION = "Bearer ";
    private static final String END_OF_STREAM = "[DONE]";
    @NonNull
    private String apiKey;
    private String organizationId;
    private String urlBase;
    private HttpClient httpClient;
    private CleverClient cleverClient;
    private OpenAI.Audios audioService;
    private OpenAI.ChatCompletions chatCompletionService;
    private OpenAI.Completions completionService;
    private OpenAI.Embeddings embeddingService;
    private OpenAI.Files fileService;
    private OpenAI.FineTunings fineTuningService;
    private OpenAI.Images imageService;
    private OpenAI.Models modelService;
    private OpenAI.Moderations moderationService;
    private OpenAI.Assistants assistantService;
    private OpenAI.Threads threadService;

    public SimpleOpenAI(String apiKey, String organizationId, String urlBase, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.organizationId = organizationId;
        this.urlBase = Optional.ofNullable(urlBase).orElse(OPENAI_URL_BASE);
        this.httpClient = Optional.ofNullable(httpClient).orElse(HttpClient.newHttpClient());
        ArrayList<Object> headers = new ArrayList<Object>();
        headers.add(AUTHORIZATION_HEADER);
        headers.add(BEARER_AUTHORIZATION + apiKey);
        if (organizationId != null) {
            headers.add(ORGANIZATION_HEADER);
            headers.add(organizationId);
        }
        this.cleverClient = CleverClient.builder().httpClient(this.httpClient).urlBase(this.urlBase).headers(headers).endOfStream(END_OF_STREAM).build();
    }

    public void setCleverClient(CleverClient cleverClient) {
        this.cleverClient = cleverClient;
    }

    public OpenAI.Audios audios() {
        if (this.audioService == null) {
            this.audioService = (OpenAI.Audios)this.cleverClient.create(OpenAI.Audios.class);
        }
        return this.audioService;
    }

    public OpenAI.ChatCompletions chatCompletions() {
        if (this.chatCompletionService == null) {
            this.chatCompletionService = (OpenAI.ChatCompletions)this.cleverClient.create(OpenAI.ChatCompletions.class);
        }
        return this.chatCompletionService;
    }

    public OpenAI.Completions completions() {
        if (this.completionService == null) {
            this.completionService = (OpenAI.Completions)this.cleverClient.create(OpenAI.Completions.class);
        }
        return this.completionService;
    }

    public OpenAI.Embeddings embeddings() {
        if (this.embeddingService == null) {
            this.embeddingService = (OpenAI.Embeddings)this.cleverClient.create(OpenAI.Embeddings.class);
        }
        return this.embeddingService;
    }

    public OpenAI.Files files() {
        if (this.fileService == null) {
            this.fileService = (OpenAI.Files)this.cleverClient.create(OpenAI.Files.class);
        }
        return this.fileService;
    }

    public OpenAI.FineTunings fineTunings() {
        if (this.fineTuningService == null) {
            this.fineTuningService = (OpenAI.FineTunings)this.cleverClient.create(OpenAI.FineTunings.class);
        }
        return this.fineTuningService;
    }

    public OpenAI.Images images() {
        if (this.imageService == null) {
            this.imageService = (OpenAI.Images)this.cleverClient.create(OpenAI.Images.class);
        }
        return this.imageService;
    }

    public OpenAI.Models models() {
        if (this.modelService == null) {
            this.modelService = (OpenAI.Models)this.cleverClient.create(OpenAI.Models.class);
        }
        return this.modelService;
    }

    public OpenAI.Moderations moderations() {
        if (this.moderationService == null) {
            this.moderationService = (OpenAI.Moderations)this.cleverClient.create(OpenAI.Moderations.class);
        }
        return this.moderationService;
    }

    public OpenAI.Assistants assistants() {
        if (this.assistantService == null) {
            this.assistantService = (OpenAI.Assistants)this.cleverClient.create(OpenAI.Assistants.class);
        }
        return this.assistantService;
    }

    public OpenAI.Threads threads() {
        if (this.threadService == null) {
            this.threadService = (OpenAI.Threads)this.cleverClient.create(OpenAI.Threads.class);
        }
        return this.threadService;
    }

    public static SimpleOpenAIBuilder builder() {
        return new SimpleOpenAIBuilder();
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public CleverClient getCleverClient() {
        return this.cleverClient;
    }

    public static class SimpleOpenAIBuilder {
        private String apiKey;
        private String organizationId;
        private String urlBase;
        private HttpClient httpClient;

        SimpleOpenAIBuilder() {
        }

        public SimpleOpenAIBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public SimpleOpenAIBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public SimpleOpenAIBuilder urlBase(String urlBase) {
            this.urlBase = urlBase;
            return this;
        }

        public SimpleOpenAIBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SimpleOpenAI build() {
            return new SimpleOpenAI(this.apiKey, this.organizationId, this.urlBase, this.httpClient);
        }

        public String toString() {
            return "SimpleOpenAI.SimpleOpenAIBuilder(apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", urlBase=" + this.urlBase + ", httpClient=" + this.httpClient + ")";
        }
    }
}

