/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.sashirestela.openai.domain.image.AbstractImageRequest;
import io.github.sashirestela.openai.domain.image.Quality;
import io.github.sashirestela.openai.domain.image.Style;
import lombok.NonNull;

public class ImageRequest
extends AbstractImageRequest {
    @NonNull
    private String prompt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Quality quality;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Style style;

    protected ImageRequest(ImageRequestBuilder<?, ?> b) {
        super(b);
        this.prompt = b.prompt;
        if (this.prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.quality = b.quality;
        this.style = b.style;
    }

    public static ImageRequestBuilder<?, ?> builder() {
        return new ImageRequestBuilderImpl();
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public Style getStyle() {
        return this.style;
    }

    private static final class ImageRequestBuilderImpl
    extends ImageRequestBuilder<ImageRequest, ImageRequestBuilderImpl> {
        private ImageRequestBuilderImpl() {
        }

        @Override
        protected ImageRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ImageRequest build() {
            return new ImageRequest(this);
        }
    }

    public static abstract class ImageRequestBuilder<C extends ImageRequest, B extends ImageRequestBuilder<C, B>>
    extends AbstractImageRequest.AbstractImageRequestBuilder<C, B> {
        private String prompt;
        private Quality quality;
        private Style style;

        public B prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return (B)this.self();
        }

        public B quality(Quality quality) {
            this.quality = quality;
            return (B)this.self();
        }

        public B style(Style style) {
            this.style = style;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageRequest.ImageRequestBuilder(super=" + super.toString() + ", prompt=" + this.prompt + ", quality=" + this.quality + ", style=" + this.style + ")";
        }
    }
}

