/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.DELETE;
import io.github.sashirestela.cleverclient.annotation.GET;
import io.github.sashirestela.cleverclient.annotation.Header;
import io.github.sashirestela.cleverclient.annotation.Multipart;
import io.github.sashirestela.cleverclient.annotation.POST;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.OpenAIDeletedResponse;
import io.github.sashirestela.openai.domain.OpenAIGeneric;
import io.github.sashirestela.openai.domain.Page;
import io.github.sashirestela.openai.domain.PageRequest;
import io.github.sashirestela.openai.domain.assistant.Assistant;
import io.github.sashirestela.openai.domain.assistant.AssistantFile;
import io.github.sashirestela.openai.domain.assistant.AssistantRequest;
import io.github.sashirestela.openai.domain.assistant.FilePath;
import io.github.sashirestela.openai.domain.assistant.Thread;
import io.github.sashirestela.openai.domain.assistant.ThreadCreateAndRunRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadMessage;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageFile;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRun;
import io.github.sashirestela.openai.domain.assistant.ThreadRunRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRunStep;
import io.github.sashirestela.openai.domain.assistant.ToolOutput;
import io.github.sashirestela.openai.domain.assistant.ToolOutputSubmission;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import io.github.sashirestela.openai.domain.audio.AudioResponse;
import io.github.sashirestela.openai.domain.audio.AudioSpeechRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranscribeRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranslateRequest;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.chat.ChatResponse;
import io.github.sashirestela.openai.domain.completion.CompletionRequest;
import io.github.sashirestela.openai.domain.completion.CompletionResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingBase64Response;
import io.github.sashirestela.openai.domain.embedding.EmbeddingFloatResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingRequest;
import io.github.sashirestela.openai.domain.embedding.EncodingFormat;
import io.github.sashirestela.openai.domain.file.FileRequest;
import io.github.sashirestela.openai.domain.file.FileResponse;
import io.github.sashirestela.openai.domain.finetuning.FineTuningEvent;
import io.github.sashirestela.openai.domain.finetuning.FineTuningRequest;
import io.github.sashirestela.openai.domain.finetuning.FineTuningResponse;
import io.github.sashirestela.openai.domain.image.ImageEditsRequest;
import io.github.sashirestela.openai.domain.image.ImageRequest;
import io.github.sashirestela.openai.domain.image.ImageResponse;
import io.github.sashirestela.openai.domain.image.ImageVariationsRequest;
import io.github.sashirestela.openai.domain.model.ModelResponse;
import io.github.sashirestela.openai.domain.moderation.ModerationRequest;
import io.github.sashirestela.openai.domain.moderation.ModerationResponse;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface OpenAI {

    @Resource(value="/v1/threads")
    @Header(name="OpenAI-Beta", value="assistants=v1")
    public static interface Threads {
        default public CompletableFuture<Thread> create() {
            return this.create(ThreadRequest.builder().build());
        }

        @POST
        public CompletableFuture<Thread> create(@Body ThreadRequest var1);

        @GET(value="/{threadId}")
        public CompletableFuture<Thread> getOne(@Path(value="threadId") String var1);

        @POST(value="/{threadId}")
        public CompletableFuture<Thread> modify(@Path(value="threadId") String var1, @Body ThreadRequest var2);

        @DELETE(value="/{threadId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="threadId") String var1);

        @POST(value="/{threadId}/messages")
        public CompletableFuture<ThreadMessage> createMessage(@Path(value="threadId") String var1, @Body ThreadMessageRequest var2);

        @GET(value="/{threadId}/messages/{messageId}")
        public CompletableFuture<ThreadMessage> getMessage(@Path(value="threadId") String var1, @Path(value="messageId") String var2);

        @POST(value="/{threadId}/messages/{messageId}")
        public CompletableFuture<ThreadMessage> modifyMessage(@Path(value="threadId") String var1, @Path(value="messageId") String var2, @Body ThreadMessageRequest var3);

        default public CompletableFuture<Page<ThreadMessage>> getMessageList(String threadId) {
            return this.getMessageList(threadId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/messages")
        public CompletableFuture<Page<ThreadMessage>> getMessageList(@Path(value="threadId") String var1, @Query PageRequest var2);

        @POST(value="/{threadId}/messages/{messageId}")
        public CompletableFuture<OpenAIDeletedResponse> deleteMessage(@Path(value="threadId") String var1, @Path(value="messageId") String var2);

        @GET(value="/{threadId}/messages/{messageId}/files/{fileId}")
        public CompletableFuture<ThreadMessageFile> getMessageFile(@Path(value="threadId") String var1, @Path(value="messageId") String var2, @Path(value="fileId") String var3);

        default public CompletableFuture<Page<ThreadMessageFile>> getMessageFileList(String threadId, String messageId) {
            return this.getMessageFileList(threadId, messageId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/messages/{messageId}/files")
        public CompletableFuture<Page<ThreadMessageFile>> getMessageFileList(@Path(value="threadId") String var1, @Path(value="messageId") String var2, @Query PageRequest var3);

        default public CompletableFuture<ThreadRun> createRun(String threadId, String assistantId) {
            return this.createRun(threadId, ThreadRunRequest.builder().assistantId(assistantId).build());
        }

        @POST(value="/{threadId}/runs")
        public CompletableFuture<ThreadRun> createRun(@Path(value="threadId") String var1, @Body ThreadRunRequest var2);

        @GET(value="/{threadId}/runs/{runId}")
        public CompletableFuture<ThreadRun> getRun(@Path(value="threadId") String var1, @Path(value="runId") String var2);

        @POST(value="/{threadId}/runs/{runId}")
        public CompletableFuture<ThreadRun> modifyRun(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ThreadRunRequest var3);

        default public CompletableFuture<Page<ThreadRun>> getRunList(String threadId) {
            return this.getRunList(threadId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/runs")
        public CompletableFuture<Page<ThreadRun>> getRunList(@Path(value="threadId") String var1, @Query PageRequest var2);

        default public CompletableFuture<ThreadRun> submitToolOutputs(String threadId, String runId, List<ToolOutput> toolOutputs) {
            return this.submitToolOutputs(threadId, runId, ToolOutputSubmission.builder().toolOutputs(toolOutputs).build());
        }

        @POST(value="/{threadId}/runs/{runId}/submit_tool_outputs")
        public CompletableFuture<ThreadRun> submitToolOutputs(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ToolOutputSubmission var3);

        @POST(value="/{threadId}/runs/{runId}/cancel")
        public CompletableFuture<ThreadRun> cancelRun(@Path(value="threadId") String var1, @Path(value="runId") String var2);

        @POST(value="/runs")
        public CompletableFuture<ThreadRun> createThreadAndRun(@Body ThreadCreateAndRunRequest var1);

        @GET(value="/{threadId}/runs/{runId}/steps/{stepId}")
        public CompletableFuture<ThreadRunStep> getRunStep(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Path(value="stepId") String var3);

        default public CompletableFuture<Page<ThreadRunStep>> getRunStepList(String threadId, String runId) {
            return this.getRunStepList(threadId, runId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/runs/{runId}/steps")
        public CompletableFuture<Page<ThreadRunStep>> getRunStepList(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Query PageRequest var3);
    }

    @Resource(value="/v1/assistants")
    @Header(name="OpenAI-Beta", value="assistants=v1")
    public static interface Assistants {
        @POST
        public CompletableFuture<Assistant> create(@Body AssistantRequest var1);

        @GET(value="/{assistantId}")
        public CompletableFuture<Assistant> getOne(@Path(value="assistantId") String var1);

        @POST(value="/{assistantId}")
        public CompletableFuture<Assistant> modify(@Path(value="assistantId") String var1, @Body AssistantRequest var2);

        @DELETE(value="/{assistantId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="assistantId") String var1);

        default public CompletableFuture<Page<Assistant>> getList() {
            return this.getList(PageRequest.builder().build());
        }

        @GET
        public CompletableFuture<Page<Assistant>> getList(@Query PageRequest var1);

        default public CompletableFuture<AssistantFile> createFile(String assistantId, String fileId) {
            return this.createFile(assistantId, FilePath.of(fileId));
        }

        @POST(value="/{assistantId}/files")
        public CompletableFuture<AssistantFile> createFile(@Path(value="assistantId") String var1, @Body FilePath var2);

        @GET(value="/{assistantId}/files/{fileId}")
        public CompletableFuture<AssistantFile> getFile(@Path(value="assistantId") String var1, @Path(value="fileId") String var2);

        @DELETE(value="/{assistantId}/files/{fileId}")
        public CompletableFuture<OpenAIDeletedResponse> deleteFile(@Path(value="assistantId") String var1, @Path(value="fileId") String var2);

        default public CompletableFuture<Page<AssistantFile>> getFileList(String assistantId) {
            return this.getFileList(assistantId, PageRequest.builder().build());
        }

        @GET(value="/{assistantId}/files")
        public CompletableFuture<Page<AssistantFile>> getFileList(@Path(value="assistantId") String var1, @Query PageRequest var2);
    }

    @Resource(value="/v1/moderations")
    public static interface Moderations {
        @POST
        public CompletableFuture<ModerationResponse> create(@Body ModerationRequest var1);
    }

    @Resource(value="/v1/models")
    public static interface Models {
        default public CompletableFuture<List<ModelResponse>> getList() {
            return this.__getList().thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<ModelResponse>> __getList();

        @GET(value="/{modelId}")
        public CompletableFuture<ModelResponse> getOne(@Path(value="modelId") String var1);

        @DELETE(value="/{modelId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="modelId") String var1);
    }

    @Resource(value="/v1/images")
    public static interface Images {
        default public CompletableFuture<List<ImageResponse>> create(ImageRequest imageRequest) {
            return this.__create(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @POST(value="/generations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> __create(@Body ImageRequest var1);

        default public CompletableFuture<List<ImageResponse>> createEdits(ImageEditsRequest imageRequest) {
            return this.__createEdits(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/edits")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> __createEdits(@Body ImageEditsRequest var1);

        default public CompletableFuture<List<ImageResponse>> createVariations(ImageVariationsRequest imageRequest) {
            return this.__createVariations(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/variations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> __createVariations(@Body ImageVariationsRequest var1);
    }

    @Resource(value="/v1/fine_tuning/jobs")
    public static interface FineTunings {
        @POST
        public CompletableFuture<FineTuningResponse> create(@Body FineTuningRequest var1);

        default public CompletableFuture<List<FineTuningResponse>> getList(Integer limit, String after) {
            return this.__getList(limit, after).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FineTuningResponse>> __getList(@Query(value="limit") Integer var1, @Query(value="after") String var2);

        @GET(value="/{fineTuningId}")
        public CompletableFuture<FineTuningResponse> getOne(@Path(value="fineTuningId") String var1);

        default public CompletableFuture<List<FineTuningEvent>> getEvents(String fineTuningId, Integer limit, String after) {
            return this.__getEvents(fineTuningId, limit, after).thenApply(OpenAIGeneric::getData);
        }

        @GET(value="/{fineTuningId}/events")
        public CompletableFuture<OpenAIGeneric<FineTuningEvent>> __getEvents(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

        @POST(value="/{fineTuningId}/cancel")
        public CompletableFuture<FineTuningResponse> cancel(@Path(value="fineTuningId") String var1);
    }

    @Resource(value="/v1/files")
    public static interface Files {
        @Multipart
        @POST
        public CompletableFuture<FileResponse> create(@Body FileRequest var1);

        default public CompletableFuture<List<FileResponse>> getList(String purpose) {
            return this.__getList(purpose).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FileResponse>> __getList(@Query(value="purpose") String var1);

        @GET(value="/{fileId}")
        public CompletableFuture<FileResponse> getOne(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<String> getContent(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<InputStream> getContentInputStream(@Path(value="fileId") String var1);

        @DELETE(value="/{fileId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="fileId") String var1);
    }

    @Resource(value="/v1/embeddings")
    public static interface Embeddings {
        default public CompletableFuture<EmbeddingFloatResponse> create(@Body EmbeddingRequest embeddingRequest) {
            EmbeddingRequest request = embeddingRequest.withEncodingFormat(EncodingFormat.FLOAT);
            return this.__create(request);
        }

        @POST
        public CompletableFuture<EmbeddingFloatResponse> __create(@Body EmbeddingRequest var1);

        default public CompletableFuture<EmbeddingBase64Response> createBase64(@Body EmbeddingRequest embeddingRequest) {
            EmbeddingRequest request = embeddingRequest.withEncodingFormat(EncodingFormat.BASE64);
            return this.__createBase64(request);
        }

        @POST
        public CompletableFuture<EmbeddingBase64Response> __createBase64(@Body EmbeddingRequest var1);
    }

    @Resource(value="/v1/completions")
    public static interface Completions {
        default public CompletableFuture<CompletionResponse> create(@Body CompletionRequest completionRequest) {
            CompletionRequest request = completionRequest.withStream(Boolean.FALSE);
            return this.__create(request);
        }

        @POST
        public CompletableFuture<CompletionResponse> __create(@Body CompletionRequest var1);

        default public CompletableFuture<Stream<CompletionResponse>> createStream(@Body CompletionRequest completionRequest) {
            CompletionRequest request = completionRequest.withStream(Boolean.TRUE);
            return this.__createStream(request);
        }

        @POST
        public CompletableFuture<Stream<CompletionResponse>> __createStream(@Body CompletionRequest var1);
    }

    @Resource(value="/v1/chat/completions")
    public static interface ChatCompletions {
        default public CompletableFuture<ChatResponse> create(@Body ChatRequest chatRequest) {
            ChatRequest request = chatRequest.withStream(Boolean.FALSE);
            return this.__create(request);
        }

        @POST
        public CompletableFuture<ChatResponse> __create(@Body ChatRequest var1);

        default public CompletableFuture<Stream<ChatResponse>> createStream(@Body ChatRequest chatRequest) {
            ChatRequest request = chatRequest.withStream(Boolean.TRUE);
            return this.__createStream(request);
        }

        @POST
        public CompletableFuture<Stream<ChatResponse>> __createStream(@Body ChatRequest var1);
    }

    @Resource(value="/v1/audio")
    public static interface Audios {
        @POST(value="/speech")
        public CompletableFuture<InputStream> speak(@Body AudioSpeechRequest var1);

        default public CompletableFuture<AudioResponse> transcribe(AudioTranscribeRequest audioRequest) {
            AudioRespFmt responseFormat = this.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.JSON, "transcribe");
            AudioTranscribeRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.__transcribe(request);
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<AudioResponse> __transcribe(@Body AudioTranscribeRequest var1);

        default public CompletableFuture<AudioResponse> translate(AudioTranslateRequest audioRequest) {
            AudioRespFmt responseFormat = this.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.JSON, "transcribe");
            AudioTranslateRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.__translate(request);
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<AudioResponse> __translate(@Body AudioTranslateRequest var1);

        default public CompletableFuture<String> transcribePlain(AudioTranscribeRequest audioRequest) {
            AudioRespFmt responseFormat = this.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.TEXT, "transcribe");
            AudioTranscribeRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.__transcribePlain(request);
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<String> __transcribePlain(@Body AudioTranscribeRequest var1);

        default public CompletableFuture<String> translatePlain(AudioTranslateRequest audioRequest) {
            AudioRespFmt responseFormat = this.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.TEXT, "transcribe");
            AudioTranslateRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.__translatePlain(request);
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<String> __translatePlain(@Body AudioTranslateRequest var1);

        private AudioRespFmt getResponseFormat(AudioRespFmt currValue, AudioRespFmt orDefault, String methodName) {
            EnumSet<AudioRespFmt> jsonEnumSet = EnumSet.of(AudioRespFmt.JSON, AudioRespFmt.VERBOSE_JSON);
            EnumSet<AudioRespFmt> textEnumSet = EnumSet.complementOf(jsonEnumSet);
            boolean isText = textEnumSet.contains((Object)orDefault);
            AudioRespFmt requestedFormat = currValue;
            if (requestedFormat != null) {
                if (isText != textEnumSet.contains((Object)requestedFormat)) {
                    throw new SimpleUncheckedException("Unexpected responseFormat for the method {0}.", methodName, null);
                }
            } else {
                requestedFormat = orDefault;
            }
            return requestedFormat;
        }
    }
}

