/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.AssistantTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AssistantRequest {
    @NonNull
    private String model;
    private String name;
    private String description;
    private String instructions;
    private List<AssistantTool> tools;
    private List<String> fileIds;
    private Map<String, String> metadata;

    AssistantRequest(@NonNull String model, String name, String description, String instructions, List<AssistantTool> tools, List<String> fileIds, Map<String, String> metadata) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
        this.name = name;
        this.description = description;
        this.instructions = instructions;
        this.tools = tools;
        this.fileIds = fileIds;
        this.metadata = metadata;
    }

    public static AssistantRequestBuilder builder() {
        return new AssistantRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<AssistantTool> getTools() {
        return this.tools;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AssistantRequestBuilder {
        private String model;
        private String name;
        private String description;
        private String instructions;
        private ArrayList<AssistantTool> tools;
        private ArrayList<String> fileIds;
        private Map<String, String> metadata;

        AssistantRequestBuilder() {
        }

        public AssistantRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public AssistantRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssistantRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AssistantRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public AssistantRequestBuilder tool(AssistantTool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public AssistantRequestBuilder tools(Collection<? extends AssistantTool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public AssistantRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public AssistantRequestBuilder fileId(String fileId) {
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.add(fileId);
            return this;
        }

        public AssistantRequestBuilder fileIds(Collection<? extends String> fileIds) {
            if (fileIds == null) {
                throw new NullPointerException("fileIds cannot be null");
            }
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.addAll(fileIds);
            return this;
        }

        public AssistantRequestBuilder clearFileIds() {
            if (this.fileIds != null) {
                this.fileIds.clear();
            }
            return this;
        }

        public AssistantRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public AssistantRequest build() {
            List<String> fileIds;
            List<AssistantTool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<AssistantTool>(this.tools));
                }
            }
            switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                case 0: {
                    fileIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    fileIds = Collections.singletonList(this.fileIds.get(0));
                    break;
                }
                default: {
                    fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                }
            }
            return new AssistantRequest(this.model, this.name, this.description, this.instructions, tools, fileIds, this.metadata);
        }

        public String toString() {
            return "AssistantRequest.AssistantRequestBuilder(model=" + this.model + ", name=" + this.name + ", description=" + this.description + ", instructions=" + this.instructions + ", tools=" + this.tools + ", fileIds=" + this.fileIds + ", metadata=" + this.metadata + ")";
        }
    }
}

