/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.chat.ChatRespFmt;
import io.github.sashirestela.openai.domain.chat.message.ChatMsg;
import io.github.sashirestela.openai.domain.chat.tool.ChatTool;
import io.github.sashirestela.openai.domain.chat.tool.ChatToolChoice;
import io.github.sashirestela.openai.domain.chat.tool.ChatToolChoiceType;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ChatRequest {
    private String model;
    private List<ChatMsg> messages;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="response_format")
    private ChatRespFmt responseFormat;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer seed;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ChatTool> tools;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double temperature;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer n;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean stream;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Object stop;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String user;

    public ChatRequest(@NonNull String model, @NonNull List<ChatMsg> messages, ChatRespFmt responseFormat, Integer seed, List<ChatTool> tools, Object toolChoice, Double temperature, Double topP, Integer n, Boolean stream, Object stop, Integer maxTokens, Double presencePenalty, Double frequencyPenalty, Map<String, Integer> logitBias, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        if (toolChoice != null && !(toolChoice instanceof ChatToolChoiceType) && !(toolChoice instanceof ChatToolChoice)) {
            throw new SimpleUncheckedException("The field toolChoice must be ChatToolChoiceType or ChatToolChoice classes.", null, null);
        }
        if (!(stop == null || stop instanceof String || stop instanceof List && ((List)stop).get(0) instanceof String && ((List)stop).size() <= 4)) {
            throw new SimpleUncheckedException("The field stop must be String or List<String> (max 4 items) classes.", null, null);
        }
        this.model = model;
        this.messages = messages;
        this.responseFormat = responseFormat;
        this.seed = seed;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static ChatRequestBuilder builder() {
        return new ChatRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<ChatMsg> getMessages() {
        return this.messages;
    }

    public ChatRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public List<ChatTool> getTools() {
        return this.tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Object getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public ChatRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ChatRequest(this.model, this.messages, this.responseFormat, this.seed, this.tools, this.toolChoice, this.temperature, this.topP, this.n, stream, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user);
    }

    public static class ChatRequestBuilder {
        private String model;
        private List<ChatMsg> messages;
        private ChatRespFmt responseFormat;
        private Integer seed;
        private List<ChatTool> tools;
        private Object toolChoice;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private Object stop;
        private Integer maxTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private String user;

        ChatRequestBuilder() {
        }

        public ChatRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public ChatRequestBuilder messages(@NonNull List<ChatMsg> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        public ChatRequestBuilder responseFormat(ChatRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ChatRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public ChatRequestBuilder tools(List<ChatTool> tools) {
            this.tools = tools;
            return this;
        }

        public ChatRequestBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ChatRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ChatRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ChatRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public ChatRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatRequestBuilder stop(Object stop) {
            this.stop = stop;
            return this;
        }

        public ChatRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public ChatRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public ChatRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public ChatRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this.model, this.messages, this.responseFormat, this.seed, this.tools, this.toolChoice, this.temperature, this.topP, this.n, this.stream, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user);
        }

        public String toString() {
            return "ChatRequest.ChatRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", responseFormat=" + this.responseFormat + ", seed=" + this.seed + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }
}

