/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.http.sender;

import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.OpenAIError;
import io.github.sashirestela.openai.support.JsonUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpSender {
    protected static Logger LOGGER = LoggerFactory.getLogger(HttpSender.class);

    public abstract <T> Object sendRequest(HttpClient var1, HttpRequest var2, Class<T> var3);

    protected void throwExceptionIfErrorIsPresent(HttpResponse<?> response, boolean isStream) {
        if (response.statusCode() != 200) {
            String data = null;
            data = isStream ? ((Stream)response.body()).collect(Collectors.joining(System.getProperty("line.separator"))) : (String)response.body();
            LOGGER.error("Response : {}", (Object)data);
            OpenAIError openAIError = JsonUtil.get().jsonToObject(data, OpenAIError.class);
            throw new SimpleUncheckedException("ERROR : {0}", openAIError.getError(), null);
        }
    }
}

