/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.http;

import io.github.sashirestela.openai.http.annotation.Path;
import io.github.sashirestela.openai.http.annotation.Query;
import io.github.sashirestela.openai.metadata.Metadata;
import java.util.List;

public class URLBuilder {
    private Metadata metadata;

    public URLBuilder(Metadata metadata) {
        this.metadata = metadata;
    }

    public String build(String methodName, Object[] arguments) {
        String PATH = Path.class.getSimpleName();
        String QUERY = Query.class.getSimpleName();
        Metadata.Method methodMetadata = this.metadata.getMethods().get(methodName);
        String url = methodMetadata.getUrl();
        List<Metadata.Parameter> pathParamList = methodMetadata.getParametersByType().get(PATH);
        List<Metadata.Parameter> queryParamList = methodMetadata.getParametersByType().get(QUERY);
        if (pathParamList.size() < 1 && queryParamList.size() < 1) {
            return url;
        }
        url = this.replacePathParams(url, pathParamList, arguments);
        url = this.includeQueryParams(url, queryParamList, arguments);
        return url;
    }

    private String replacePathParams(String url, List<Metadata.Parameter> paramList, Object[] arguments) {
        for (Metadata.Parameter paramMetadata : paramList) {
            int index = paramMetadata.getIndex();
            String pathParam = "{" + paramMetadata.getAnnotationValue() + "}";
            url = url.replace(pathParam, arguments[index].toString());
        }
        return url;
    }

    private String includeQueryParams(String url, List<Metadata.Parameter> paramList, Object[] arguments) {
        boolean first = true;
        for (Metadata.Parameter paramMetadata : paramList) {
            String prefix;
            int index = paramMetadata.getIndex();
            Object value = arguments[index];
            if (value == null) continue;
            if (first) {
                prefix = "?";
                first = false;
            } else {
                prefix = "&";
            }
            String queryParam = paramMetadata.getAnnotationValue();
            url = (String)url + prefix + queryParam + "=" + value.toString();
        }
        return url;
    }
}

