/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.http;

import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.http.HttpConnector;
import io.github.sashirestela.openai.http.HttpInvocationHandler;
import io.github.sashirestela.openai.http.InvocationFilter;
import io.github.sashirestela.openai.http.ReturnType;
import io.github.sashirestela.openai.http.URLBuilder;
import io.github.sashirestela.openai.http.annotation.Body;
import io.github.sashirestela.openai.http.annotation.Path;
import io.github.sashirestela.openai.metadata.Metadata;
import io.github.sashirestela.openai.metadata.MetadataCollector;
import io.github.sashirestela.openai.support.CommonUtil;
import io.github.sashirestela.openai.support.Constant;
import io.github.sashirestela.openai.support.ReflectUtil;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(HttpProcessor.class);
    @NonNull
    private HttpClient httpClient;
    @NonNull
    private String urlBase;
    private List<String> headers;
    private Metadata metadata;
    private URLBuilder urlBuilder;

    public HttpProcessor(HttpClient httpClient, String urlBase, List<String> headers) {
        this.httpClient = httpClient;
        this.urlBase = urlBase;
        this.headers = headers;
    }

    public <T> T create(Class<T> interfaceClass, InvocationFilter filter) {
        this.metadata = MetadataCollector.get().collect(interfaceClass);
        this.validateMetadata();
        this.urlBuilder = new URLBuilder(this.metadata);
        HttpInvocationHandler httpInvocationHandler = new HttpInvocationHandler(this, filter);
        T proxy = ReflectUtil.get().createProxy(interfaceClass, httpInvocationHandler);
        LOGGER.debug("Created Instance : {}", (Object)interfaceClass.getSimpleName());
        return proxy;
    }

    public Object resolve(Method method, Object[] arguments) {
        String methodName = method.getName();
        Metadata.Method methodMetadata = this.metadata.getMethods().get(methodName);
        String url = this.urlBase + this.urlBuilder.build(methodName, arguments);
        String httpMethod = methodMetadata.getHttpAnnotation().getName();
        ReturnType returnType = methodMetadata.getReturnType();
        boolean isMultipart = methodMetadata.isMultipart();
        Object bodyObject = this.calculateBodyObject(methodMetadata, arguments);
        ArrayList<String> headers = new ArrayList<String>(this.headers);
        headers.addAll(this.calculateHeaderContentType(bodyObject, isMultipart));
        String[] headersArray = headers.toArray(new String[0]);
        HttpConnector httpConnector = HttpConnector.builder().httpClient(this.httpClient).url(url).httpMethod(httpMethod).returnType(returnType).bodyObject(bodyObject).isMultipart(isMultipart).headersArray(headersArray).build();
        LOGGER.debug("Http Call : {} {}", (Object)httpMethod, (Object)url);
        Object responseObject = httpConnector.sendRequest();
        return responseObject;
    }

    private void validateMetadata() {
        this.metadata.getMethods().forEach((methodName, methodMetadata) -> Optional.ofNullable(methodMetadata.getHttpAnnotation()).orElseThrow(() -> new SimpleUncheckedException("Missing HTTP anotation for the method {0}.", methodName, null)));
        String PATH = Path.class.getSimpleName();
        this.metadata.getMethods().forEach((methodName, methodMetadata) -> {
            String url = methodMetadata.getUrl();
            List<String> listPathParams = CommonUtil.get().findFullMatches(url, "\\{(.*?)\\}");
            if (!CommonUtil.get().isNullOrEmpty(listPathParams)) {
                listPathParams.forEach(pathParam -> methodMetadata.getParametersByType().get(PATH).stream().filter(paramMetadata -> pathParam.equals(paramMetadata.getAnnotationValue())).findFirst().orElseThrow(() -> new SimpleUncheckedException("Path param {0} in the url cannot find an annotated argument in the method {1}.", pathParam, methodName, null)));
            }
        });
    }

    private Object calculateBodyObject(Metadata.Method methodMetadata, Object[] arguments) {
        String BODY = Body.class.getSimpleName();
        Integer indexBody = methodMetadata.getParametersByType().get(BODY).stream().map(paramMetadata -> paramMetadata.getIndex()).findFirst().orElse(-1);
        Object bodyObject = indexBody >= 0 ? arguments[indexBody] : null;
        return bodyObject;
    }

    private List<String> calculateHeaderContentType(Object bodyObject, boolean isMultipart) {
        ArrayList<String> headerContentType = new ArrayList<String>();
        if (bodyObject != null) {
            Object contentType = isMultipart ? "multipart/form-data; boundary=\"" + Constant.BOUNDARY_VALUE + "\"" : "application/json";
            headerContentType.add("Content-Type");
            headerContentType.add((String)contentType);
        }
        return headerContentType;
    }

    public static HttpProcessorBuilder builder() {
        return new HttpProcessorBuilder();
    }

    public HttpProcessor() {
    }

    @NonNull
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @NonNull
    public String getUrlBase() {
        return this.urlBase;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public URLBuilder getUrlBuilder() {
        return this.urlBuilder;
    }

    public static class HttpProcessorBuilder {
        private HttpClient httpClient;
        private String urlBase;
        private List<String> headers;

        HttpProcessorBuilder() {
        }

        public HttpProcessorBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public HttpProcessorBuilder urlBase(String urlBase) {
            this.urlBase = urlBase;
            return this;
        }

        public HttpProcessorBuilder headers(List<String> headers) {
            this.headers = headers;
            return this;
        }

        public HttpProcessor build() {
            return new HttpProcessor(this.httpClient, this.urlBase, this.headers);
        }

        public String toString() {
            return "HttpProcessor.HttpProcessorBuilder(httpClient=" + this.httpClient + ", urlBase=" + this.urlBase + ", headers=" + this.headers + ")";
        }
    }
}

