/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.domain.image.ImageRespFmt;
import io.github.sashirestela.openai.domain.image.Size;

public abstract class AbstractImageRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Integer n;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Size size;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="response_format")
    protected ImageRespFmt responseFormat;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String user;

    protected AbstractImageRequest(AbstractImageRequestBuilder<?, ?> b) {
        this.n = b.n;
        this.size = b.size;
        this.responseFormat = b.responseFormat;
        this.user = b.user;
    }

    public AbstractImageRequest() {
    }

    public AbstractImageRequest(Integer n, Size size, ImageRespFmt responseFormat, String user) {
        this.n = n;
        this.size = size;
        this.responseFormat = responseFormat;
        this.user = user;
    }

    public Integer getN() {
        return this.n;
    }

    public Size getSize() {
        return this.size;
    }

    public ImageRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return "AbstractImageRequest(n=" + this.getN() + ", size=" + this.getSize() + ", responseFormat=" + this.getResponseFormat() + ", user=" + this.getUser() + ")";
    }

    public static abstract class AbstractImageRequestBuilder<C extends AbstractImageRequest, B extends AbstractImageRequestBuilder<C, B>> {
        private Integer n;
        private Size size;
        private ImageRespFmt responseFormat;
        private String user;

        public B n(Integer n) {
            this.n = n;
            return this.self();
        }

        public B size(Size size) {
            this.size = size;
            return this.self();
        }

        @JsonProperty(value="response_format")
        public B responseFormat(ImageRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this.self();
        }

        public B user(String user) {
            this.user = user;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractImageRequest.AbstractImageRequestBuilder(n=" + this.n + ", size=" + this.size + ", responseFormat=" + this.responseFormat + ", user=" + this.user + ")";
        }
    }
}

