/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.http.sender;

import io.github.sashirestela.openai.domain.OpenAIEvent;
import io.github.sashirestela.openai.http.sender.HttpSender;
import io.github.sashirestela.openai.support.JsonUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;

public class HttpAsyncStreamSender
extends HttpSender {
    @Override
    public <T> Object sendRequest(HttpClient httpClient, HttpRequest httpRequest, Class<T> responseClass) {
        CompletableFuture<HttpResponse<Stream<String>>> httpResponseFuture = httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofLines());
        CompletionStage objResponseFuture = httpResponseFuture.thenApply(response -> {
            this.throwExceptionIfErrorIsPresent((HttpResponse<?>)response, true);
            Stream<Object> objResponse = ((Stream)response.body()).peek(rawData -> LOGGER.debug("Response : {}", rawData)).map(rawData -> new OpenAIEvent((String)rawData)).filter(event -> event.isActualData()).map(event -> JsonUtil.get().jsonToObject(event.getActualData(), responseClass));
            return objResponse;
        });
        return objResponseFuture;
    }
}

