/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.filter;

import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import io.github.sashirestela.openai.domain.audio.AudioTranslateRequest;
import io.github.sashirestela.openai.http.InvocationFilter;
import io.github.sashirestela.openai.http.ReturnType;
import java.lang.reflect.Method;
import java.util.EnumSet;

public class AudioFilter
implements InvocationFilter {
    private static final EnumSet<AudioRespFmt> JSON_FMT = EnumSet.of(AudioRespFmt.JSON, AudioRespFmt.VERBOSE_JSON);
    private static final EnumSet<AudioRespFmt> TEXT_FMT = EnumSet.complementOf(JSON_FMT);

    @Override
    public void apply(Method method, Object[] arguments) {
        Class<?> responseClass = new ReturnType(method).getBaseClass();
        AudioTranslateRequest requestObj = (AudioTranslateRequest)arguments[0];
        AudioRespFmt responseFormat = requestObj.getResponseFormat();
        if (responseClass.getSimpleName().equals("String")) {
            if (responseFormat != null) {
                if (!TEXT_FMT.contains((Object)responseFormat)) {
                    throw new SimpleUncheckedException("Unexpected responseFormat for the method {0}.", method.getName(), null);
                }
            } else {
                requestObj.setResponseFormat(AudioRespFmt.TEXT);
            }
        } else if (responseFormat != null) {
            if (!JSON_FMT.contains((Object)responseFormat)) {
                throw new SimpleUncheckedException("Unexpected responseFormat for the method {0}.", method.getName(), null);
            }
        } else {
            requestObj.setResponseFormat(AudioRespFmt.JSON);
        }
    }
}

