/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.image;

import io.github.sashirestela.openai.domain.image.AbstractImageRequest;
import lombok.NonNull;

public class ImageRequest
extends AbstractImageRequest {
    @NonNull
    private String prompt;

    protected ImageRequest(ImageRequestBuilder<?, ?> b) {
        super(b);
        this.prompt = b.prompt;
        if (this.prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
    }

    public static ImageRequestBuilder<?, ?> builder() {
        return new ImageRequestBuilderImpl();
    }

    public ImageRequest() {
    }

    public ImageRequest(@NonNull String prompt) {
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.prompt = prompt;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public String toString() {
        return "ImageRequest(prompt=" + this.getPrompt() + ")";
    }

    private static final class ImageRequestBuilderImpl
    extends ImageRequestBuilder<ImageRequest, ImageRequestBuilderImpl> {
        private ImageRequestBuilderImpl() {
        }

        @Override
        protected ImageRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ImageRequest build() {
            return new ImageRequest(this);
        }
    }

    public static abstract class ImageRequestBuilder<C extends ImageRequest, B extends ImageRequestBuilder<C, B>>
    extends AbstractImageRequest.AbstractImageRequestBuilder<C, B> {
        private String prompt;

        public B prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageRequest.ImageRequestBuilder(super=" + super.toString() + ", prompt=" + this.prompt + ")";
        }
    }
}

